/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.client.handler;

import fuzs.puzzleslib.api.client.gui.v2.tooltip.TooltipBuilder;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.client.handler.OpenMountInventoryHandler;
import fuzs.vehicleupgrade.config.ClientConfig;
import fuzs.vehicleupgrade.config.VehicleInventory;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5348;
import net.minecraft.class_7706;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class MountInventoryButtonHandler {
    public static final class_8666 CROSS_SPRITES = new class_8666(VehicleUpgrade.id("container/inventory/cross"), VehicleUpgrade.id("container/inventory/cross_highlighted"));
    static final class_2561 INVENTORY_COMPONENT = class_2561.method_43471((String)"container.inventory");
    @Nullable
    private static class_4185 playerInventoryButton;

    public static void onAfterInit(class_310 minecraft, class_465<?> screen, int screenWidth, int screenHeight, List<class_339> widgets, UnaryOperator<class_339> addWidget, Consumer<class_339> removeWidget) {
        if (minecraft.field_1755 == screen && OpenMountInventoryHandler.isServerControlledInventory((class_1657)minecraft.field_1724)) {
            class_4185 vehicleInventoryButton;
            playerInventoryButton = MountInventoryButtonHandler.createPlayerInventoryButton(screen);
            MountInventoryButtonHandler.updatePlayerInventoryButtons(screen, playerInventoryButton);
            if (playerInventoryButton != null) {
                addWidget.apply((class_339)playerInventoryButton);
            }
            if ((vehicleInventoryButton = MountInventoryButtonHandler.createVehicleInventoryButton(screen)) != null) {
                addWidget.apply((class_339)vehicleInventoryButton);
            }
        }
    }

    @Nullable
    private static class_4185 createPlayerInventoryButton(class_465<?> screen) {
        Vector2i vector2i = MountInventoryButtonHandler.getButtonPositions(screen);
        class_1297 playerVehicle = screen.field_22787.field_1724.method_5854();
        if (vector2i != null && playerVehicle != null) {
            class_344 button = new class_344(vector2i.x(), vector2i.y(), 13, 13, CROSS_SPRITES, buttonX -> VehicleInventory.VEHICLE.openInventory(screen.field_22787, (class_437)screen));
            TooltipBuilder.create((class_5348[])new class_5348[]{playerVehicle.method_5476()}).build((class_339)button);
            return button;
        }
        return null;
    }

    @Nullable
    public static Vector2i getButtonPositions(class_465<?> screen) {
        if (screen instanceof class_481) {
            return new Vector2i(screen.field_2776 + screen.field_2792 - 13 - 7, screen.field_2800 + 3 + (MountInventoryButtonHandler.hasAdditionalPages(screen.field_22787) ? 14 : 0));
        }
        if (screen instanceof class_490) {
            return new Vector2i(screen.field_2776 + screen.field_2792 - 13 - 7, screen.field_2800 + 3);
        }
        return null;
    }

    private static boolean hasAdditionalPages(class_310 minecraft) {
        if (ModLoaderEnvironment.INSTANCE.getModLoader().isFabricLike()) {
            int tabs = minecraft.field_1724.method_7338() && (Boolean)minecraft.field_1690.method_47395().method_41753() != false ? 14 : 13;
            return class_7706.method_47335().size() > tabs;
        }
        return false;
    }

    @Nullable
    private static class_4185 createVehicleInventoryButton(class_465<?> screen) {
        if (!((ClientConfig)VehicleUpgrade.CONFIG.get(ClientConfig.class)).vehicleInventoryButton) {
            return null;
        }
        if (!VehicleInventory.isPlayerInventory(screen)) {
            class_344 button = new class_344(screen.field_2776 + screen.field_2792 - 13 - 7, screen.field_2800 + 3, 13, 13, CROSS_SPRITES, buttonX -> VehicleInventory.PLAYER.openInventory(screen.field_22787, (class_437)screen));
            TooltipBuilder.create((class_5348[])new class_5348[]{INVENTORY_COMPONENT}).build((class_339)button);
            return button;
        }
        return null;
    }

    public static void onAfterMouseClick(class_465<?> screen, class_11909 mouseButtonEvent) {
        MountInventoryButtonHandler.updatePlayerInventoryButtons(screen, playerInventoryButton);
    }

    public static void onAfterKeyPress(class_465<?> screen, class_11908 keyEvent) {
        MountInventoryButtonHandler.updatePlayerInventoryButtons(screen, playerInventoryButton);
    }

    public static void onAfterMouseRelease(class_465<?> screen, class_11909 mouseButtonEvent) {
        MountInventoryButtonHandler.updatePlayerInventoryButtons(screen, playerInventoryButton);
    }

    private static void updatePlayerInventoryButtons(class_465<?> screen, @Nullable class_4185 button) {
        if (button != null) {
            if (screen instanceof class_490) {
                Vector2i vector2i = MountInventoryButtonHandler.getButtonPositions(screen);
                Objects.requireNonNull(vector2i, "button positions is null");
                button.method_46421(vector2i.x());
            }
            if (screen instanceof class_481) {
                class_481 inventoryScreen = (class_481)screen;
                if (MountInventoryButtonHandler.hasAdditionalPages(screen.field_22787)) {
                    button.field_22764 = inventoryScreen.method_47424();
                }
            }
        }
    }

    public static void onRemove(class_465<?> screen) {
        if (VehicleInventory.isPlayerInventory(screen)) {
            playerInventoryButton = null;
        }
    }
}

