/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.client.gui.components;

import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface RenderableComponent {
    public int getWidth(Font var1);

    public void renderComponent(GuiGraphics var1, Font var2, int var3, int var4);

    public static int getFullWidth(Stream<RenderableComponent> stream, Font font) {
        return stream.mapToInt(component -> component.getWidth(font)).sum();
    }

    public static void renderComponents(GuiGraphics guiGraphics, Font font, int posX, int posY, Collection<RenderableComponent> list) {
        posX -= RenderableComponent.getFullWidth(list.stream(), font) / 2;
        for (RenderableComponent component : list) {
            component.renderComponent(guiGraphics, font, posX, posY);
            posX += component.getWidth(font);
        }
    }

    public static RenderableComponent ofText(final Component component) {
        return new RenderableComponent(){

            @Override
            public int getWidth(Font font) {
                return font.width((FormattedText)component);
            }

            @Override
            public void renderComponent(GuiGraphics guiGraphics, Font font, int posX, int posY) {
                guiGraphics.drawString(font, component, posX, posY, -12566464, false);
            }
        };
    }

    public static RenderableComponent ofSprite(ResourceLocation resourceLocation, int iconSize) {
        return RenderableComponent.ofSprite(resourceLocation, resourceLocation, iconSize, iconSize);
    }

    public static RenderableComponent ofSprite(final ResourceLocation foregroundLocation, final @Nullable ResourceLocation backgroundLocation, final int iconSize, final int iconWidth) {
        final int iconOffsetX = (iconWidth - iconSize) / 2;
        return new RenderableComponent(){

            @Override
            public int getWidth(Font font) {
                return iconWidth;
            }

            @Override
            public void renderComponent(GuiGraphics guiGraphics, Font font, int posX, int posY) {
                if (backgroundLocation != null) {
                    guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, backgroundLocation, posX + iconOffsetX, posY, iconSize, iconSize);
                }
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, foregroundLocation, posX + iconOffsetX, posY, iconSize, iconSize);
            }
        };
    }
}

