/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.puzzleslib.api.client.renderer.v1.RenderPropertyKey;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.config.ClientConfig;
import fuzs.vehicleupgrade.init.ModRegistry;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class TranslucentMountHandler {
    private static final RenderPropertyKey<Optional<Float>> VEHICLE_ALPHA_RENDER_PROPERTY = new RenderPropertyKey(VehicleUpgrade.id("vehicle_alpha"));
    private static Optional<Float> vehicleAlpha = Optional.empty();

    public static void onExtractRenderState(Entity entity, EntityRenderState renderState, float partialTick) {
        if (!((ClientConfig)VehicleUpgrade.CONFIG.get(ClientConfig.class)).translucentMount) {
            return;
        }
        if (Minecraft.getInstance().screen != null || !entity.getType().is(ModRegistry.TRANSLUCENT_MOUNTS_ENTITY_TYPE_TAG)) {
            return;
        }
        Entity cameraEntity = Minecraft.getInstance().getCameraEntity();
        if (cameraEntity != null && entity.isVehicle() && entity.hasPassenger(cameraEntity)) {
            float alphaValue = Mth.clamp((float)((cameraEntity.getXRot(partialTick) - 15.0f) / 45.0f), (float)0.0f, (float)1.0f);
            RenderPropertyKey.set((EntityRenderState)renderState, VEHICLE_ALPHA_RENDER_PROPERTY, Optional.of(Float.valueOf(1.0f - 0.9f * alphaValue)));
        }
    }

    public static <T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>> EventResult onBeforeRenderEntity(S entityRenderState, LivingEntityRenderer<T, S, M> entityRenderer, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (RenderPropertyKey.has(entityRenderState, VEHICLE_ALPHA_RENDER_PROPERTY)) {
            vehicleAlpha = (Optional)RenderPropertyKey.getOrDefault(entityRenderState, VEHICLE_ALPHA_RENDER_PROPERTY, Optional.empty());
        }
        return EventResult.PASS;
    }

    public static <T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>> void onAfterRenderEntity(S entityRenderState, LivingEntityRenderer<T, S, M> entityRenderer, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        vehicleAlpha = Optional.empty();
    }

    public static int getColorWithAlpha(int color) {
        if (vehicleAlpha.isPresent()) {
            return ARGB.color((float)vehicleAlpha.get().floatValue(), (int)color);
        }
        return color;
    }

    public static RenderType getTranslucentRenderType(RenderType renderType) {
        if (vehicleAlpha.isPresent() && renderType instanceof RenderType.CompositeRenderType) {
            Optional cutoutedTexture;
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
            if (compositeRenderType.renderPipeline.getBlendFunction().isEmpty() && (cutoutedTexture = compositeRenderType.state.textureState.cutoutTexture()).isPresent()) {
                return RenderType.entityTranslucent((ResourceLocation)((ResourceLocation)cutoutedTexture.get()));
            }
        }
        return renderType;
    }
}

