/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.util.v1.CommonHelper;
import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.config.ServerConfig;
import fuzs.vehicleupgrade.init.ModRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VehicleUpgradeHandler {
    public static EventResultHolder<InteractionResult> onUseEntity(Player player, Level level, InteractionHand interactionHand, Entity entity) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).manuallyDismountPassengers) {
            return EventResultHolder.pass();
        }
        if (player.isSecondaryUseActive() && player.getItemInHand(interactionHand).isEmpty() && entity.isPassenger() && !(entity instanceof Player) && entity.getVehicle() instanceof VehicleEntity) {
            entity.stopRiding();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.getNavigation().stop();
            }
            return EventResultHolder.interrupt((Object)InteractionResult.SUCCESS);
        }
        return EventResultHolder.pass();
    }

    public static EventResult onStartRiding(Level level, Entity passengerEntity, Entity vehicleEntity) {
        if (!((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).rotateVehicleWithPlayer) {
            return EventResult.PASS;
        }
        if (!vehicleEntity.hasControllingPassenger() && passengerEntity instanceof Player) {
            Player player = (Player)passengerEntity;
            vehicleEntity.setYRot(player.getYRot());
            vehicleEntity.yRotO = player.getYRot();
            if (vehicleEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)vehicleEntity;
                livingEntity.yBodyRot = livingEntity.yBodyRotO = player.yBodyRot;
                livingEntity.yHeadRot = livingEntity.yHeadRotO = player.yHeadRot;
            }
        }
        return EventResult.PASS;
    }

    public static Optional<VoxelShape> getRidingTraversableShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        EntityCollisionContext context;
        return collisionContext instanceof EntityCollisionContext && VehicleUpgradeHandler.isRidingTraversable(blockState, (context = (EntityCollisionContext)collisionContext).getEntity()) ? Optional.of(Shapes.empty()) : Optional.empty();
    }

    public static boolean isRidingTraversable(BlockState blockState, @Nullable Entity entity) {
        if (CommonHelper.getMinecraftServer() == null || !((ServerConfig)VehicleUpgrade.CONFIG.get(ServerConfig.class)).mountsPassThroughLeaves) {
            return false;
        }
        if (VehicleUpgradeHandler.isTraversableEntity(entity)) {
            return blockState.is(ModRegistry.RIDING_TRAVERSABLE_BLOCK_TAG);
        }
        return false;
    }

    private static boolean isTraversableEntity(@Nullable Entity entity) {
        if (entity != null) {
            if (entity.hasControllingPassenger() && entity.getType().is(ModRegistry.TRAVERSABLE_MOUNTS_ENTITY_TYPE_TAG)) {
                return true;
            }
            if (entity.isPassenger() && entity.getVehicle().getType().is(ModRegistry.TRAVERSABLE_MOUNTS_ENTITY_TYPE_TAG)) {
                return true;
            }
        }
        return false;
    }
}

