/*
 * Decompiled with CFR 0.152.
 */
package net.toopa.unusualfurniture.block;

import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.toopa.unusualfurniture.block.entity.AcaciaDrawerBlockEntity;
import net.toopa.unusualfurniture.procedures.PlaceSmokeProcedure;
import net.toopa.unusualfurniture.world.inventory.DrawerGUIMenu;

public class AcaciaDrawerBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)1);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public AcaciaDrawerBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(1.0f, 10.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                return 0;
            }
        }.getLightLevel()).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).dynamicShape().ignitedByLava().instrument(NoteBlockInstrument.BASS));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 1) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Shapes.or((VoxelShape)AcaciaDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{AcaciaDrawerBlock.box((double)1.0, (double)7.0, (double)12.0, (double)15.0, (double)13.0, (double)22.0), AcaciaDrawerBlock.box((double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)7.0, (double)26.0)});
                case Direction.NORTH -> Shapes.or((VoxelShape)AcaciaDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{AcaciaDrawerBlock.box((double)1.0, (double)7.0, (double)-6.0, (double)15.0, (double)13.0, (double)4.0), AcaciaDrawerBlock.box((double)1.0, (double)1.0, (double)-10.0, (double)15.0, (double)7.0, (double)0.0)});
                case Direction.EAST -> Shapes.or((VoxelShape)AcaciaDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{AcaciaDrawerBlock.box((double)12.0, (double)7.0, (double)1.0, (double)22.0, (double)13.0, (double)15.0), AcaciaDrawerBlock.box((double)16.0, (double)1.0, (double)1.0, (double)26.0, (double)7.0, (double)15.0)});
                case Direction.WEST -> Shapes.or((VoxelShape)AcaciaDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{AcaciaDrawerBlock.box((double)-6.0, (double)7.0, (double)1.0, (double)4.0, (double)13.0, (double)15.0), AcaciaDrawerBlock.box((double)-10.0, (double)1.0, (double)1.0, (double)0.0, (double)7.0, (double)15.0)});
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> AcaciaDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.NORTH -> AcaciaDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.EAST -> AcaciaDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.WEST -> AcaciaDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState blockstate, LivingEntity entity, ItemStack itemstack) {
        super.setPlacedBy(world, pos, blockstate, entity, itemstack);
        PlaceSmokeProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Acacia Drawer");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new DrawerGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AcaciaDrawerBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof AcaciaDrawerBlockEntity) {
                AcaciaDrawerBlockEntity be = (AcaciaDrawerBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof AcaciaDrawerBlockEntity) {
            AcaciaDrawerBlockEntity be = (AcaciaDrawerBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

