/*
 * Decompiled with CFR 0.152.
 */
package net.toopa.unusualfurniture.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.toopa.unusualfurniture.procedures.SphereLampTickUpdateProcedure;

public class SphereLampBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)1);
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public SphereLampBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.GLASS).strength(1.0f, 10.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                return 15;
            }
        }.getLightLevel()).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).dynamicShape());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.unusual_furniture.sphere_lamp.description_0"));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)SphereLampBlock.box((double)5.0, (double)4.95, (double)-0.05, (double)11.0, (double)10.95, (double)1.95), (VoxelShape[])new VoxelShape[]{SphereLampBlock.box((double)6.0, (double)5.95, (double)3.95, (double)10.0, (double)9.95, (double)7.95), SphereLampBlock.box((double)7.0, (double)6.95, (double)1.95, (double)9.0, (double)8.95, (double)3.95), SphereLampBlock.box((double)3.0, (double)2.95, (double)1.95, (double)13.0, (double)12.95, (double)10.95), SphereLampBlock.box((double)5.0, (double)4.95, (double)10.95, (double)11.0, (double)10.95, (double)11.95)});
            case Direction.NORTH -> Shapes.or((VoxelShape)SphereLampBlock.box((double)5.0, (double)4.95, (double)14.05, (double)11.0, (double)10.95, (double)16.05), (VoxelShape[])new VoxelShape[]{SphereLampBlock.box((double)6.0, (double)5.95, (double)8.05, (double)10.0, (double)9.95, (double)12.05), SphereLampBlock.box((double)7.0, (double)6.95, (double)12.05, (double)9.0, (double)8.95, (double)14.05), SphereLampBlock.box((double)3.0, (double)2.95, (double)5.05, (double)13.0, (double)12.95, (double)14.05), SphereLampBlock.box((double)5.0, (double)4.95, (double)4.05, (double)11.0, (double)10.95, (double)5.05)});
            case Direction.EAST -> Shapes.or((VoxelShape)SphereLampBlock.box((double)-0.05, (double)4.95, (double)5.0, (double)1.95, (double)10.95, (double)11.0), (VoxelShape[])new VoxelShape[]{SphereLampBlock.box((double)3.95, (double)5.95, (double)6.0, (double)7.95, (double)9.95, (double)10.0), SphereLampBlock.box((double)1.95, (double)6.95, (double)7.0, (double)3.95, (double)8.95, (double)9.0), SphereLampBlock.box((double)1.95, (double)2.95, (double)3.0, (double)10.95, (double)12.95, (double)13.0), SphereLampBlock.box((double)10.95, (double)4.95, (double)5.0, (double)11.95, (double)10.95, (double)11.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)SphereLampBlock.box((double)14.05, (double)4.95, (double)5.0, (double)16.05, (double)10.95, (double)11.0), (VoxelShape[])new VoxelShape[]{SphereLampBlock.box((double)8.05, (double)5.95, (double)6.0, (double)12.05, (double)9.95, (double)10.0), SphereLampBlock.box((double)12.05, (double)6.95, (double)7.0, (double)14.05, (double)8.95, (double)9.0), SphereLampBlock.box((double)5.05, (double)2.95, (double)3.0, (double)14.05, (double)12.95, (double)13.0), SphereLampBlock.box((double)4.05, (double)4.95, (double)5.0, (double)5.05, (double)10.95, (double)11.0)});
            case Direction.UP -> Shapes.or((VoxelShape)SphereLampBlock.box((double)5.0, (double)-0.05, (double)4.95, (double)11.0, (double)1.95, (double)10.95), (VoxelShape[])new VoxelShape[]{SphereLampBlock.box((double)6.0, (double)3.95, (double)5.95, (double)10.0, (double)7.95, (double)9.95), SphereLampBlock.box((double)7.0, (double)1.95, (double)6.95, (double)9.0, (double)3.95, (double)8.95), SphereLampBlock.box((double)3.0, (double)1.95, (double)2.95, (double)13.0, (double)10.95, (double)12.95), SphereLampBlock.box((double)5.0, (double)10.95, (double)4.95, (double)11.0, (double)11.95, (double)10.95)});
            case Direction.DOWN -> Shapes.or((VoxelShape)SphereLampBlock.box((double)5.0, (double)14.05, (double)5.05, (double)11.0, (double)16.05, (double)11.05), (VoxelShape[])new VoxelShape[]{SphereLampBlock.box((double)6.0, (double)8.05, (double)6.05, (double)10.0, (double)12.05, (double)10.05), SphereLampBlock.box((double)7.0, (double)12.05, (double)7.05, (double)9.0, (double)14.05, (double)9.05), SphereLampBlock.box((double)3.0, (double)5.05, (double)3.05, (double)13.0, (double)14.05, (double)13.05), SphereLampBlock.box((double)5.0, (double)4.05, (double)5.05, (double)11.0, (double)5.05, (double)11.05)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 60);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        SphereLampTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 60);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState blockstate, LivingEntity entity, ItemStack itemstack) {
        super.setPlacedBy(world, pos, blockstate, entity, itemstack);
        SphereLampTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

