/*
 * Decompiled with CFR 0.152.
 */
package net.toopa.unusualfurniture.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.toopa.unusualfurniture.init.UnusualFurnitureModScreens;
import net.toopa.unusualfurniture.network.TableGUIButtonMessage;
import net.toopa.unusualfurniture.procedures.ItemPlacePopUpConditionsProcedure;
import net.toopa.unusualfurniture.procedures.SwitchOffDisplayConditionsProcedure;
import net.toopa.unusualfurniture.world.inventory.TableGUIMenu;

public class TableGUIScreen
extends AbstractContainerScreen<TableGUIMenu>
implements UnusualFurnitureModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    ImageButton imagebutton_switch_button;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"unusual_furniture:textures/screens/table_gui.png");

    public TableGUIScreen(TableGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 72;
        this.imageHeight = 27;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(ResourceLocation.parse((String)"unusual_furniture:textures/screens/table_gui_overlay.png"), this.leftPos + -52, this.topPos + -112, 0.0f, 0.0f, 176, 208, 176, 208);
        if (ItemPlacePopUpConditionsProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z)) {
            guiGraphics.blit(ResourceLocation.parse((String)"unusual_furniture:textures/screens/place_items_here.png"), this.leftPos + -112, this.topPos + -103, 0.0f, 0.0f, 88, 85, 88, 85);
        }
        if (SwitchOffDisplayConditionsProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z)) {
            guiGraphics.blit(ResourceLocation.parse((String)"unusual_furniture:textures/screens/switch_off.png"), this.leftPos + 24, this.topPos + 0, 0.0f, 0.0f, 22, 11, 22, 11);
        }
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (ItemPlacePopUpConditionsProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z)) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.unusual_furniture.table_gui.label_place_items_here"), -106, -69, -1, false);
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.unusual_furniture.table_gui.label_item_rotation_settings"), -46, -10, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.unusual_furniture.table_gui.label_classic"), -27, 2, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.unusual_furniture.table_gui.label_random"), 61, 2, -12829636, false);
    }

    public void init() {
        super.init();
        this.imagebutton_switch_button = new ImageButton(this, this.leftPos + 24, this.topPos + 0, 22, 11, new WidgetSprites(ResourceLocation.parse((String)"unusual_furniture:textures/screens/switch_button.png"), ResourceLocation.parse((String)"unusual_furniture:textures/screens/switch_button.png")), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new TableGUIButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            TableGUIButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.imagebutton_switch_button);
    }
}

