/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.input.InputQuirks;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public final class GameKeys {
    protected static final String KEY = "key";
    protected static final String CATEGORIES = "categories";
    protected static final String DELIMITER = ".";

    public static boolean affectPlayer() {
        return Minecraft.getInstance().screen == null;
    }

    public static boolean affectMenus() {
        return !GameKeys.affectPlayer();
    }

    public static Options getGameSettings() {
        return Minecraft.getInstance().options;
    }

    public static Window getMainWindow() {
        return Minecraft.getInstance().getWindow();
    }

    public static boolean isShiftDown() {
        return InputConstants.isKeyDown((Window)GameKeys.getMainWindow(), (int)340) || InputConstants.isKeyDown((Window)GameKeys.getMainWindow(), (int)344);
    }

    public static boolean isControlDown() {
        if (InputQuirks.REPLACE_CTRL_KEY_WITH_CMD_KEY) {
            return InputConstants.isKeyDown((Window)GameKeys.getMainWindow(), (int)343) || InputConstants.isKeyDown((Window)GameKeys.getMainWindow(), (int)347);
        }
        return InputConstants.isKeyDown((Window)GameKeys.getMainWindow(), (int)341) || InputConstants.isKeyDown((Window)GameKeys.getMainWindow(), (int)345);
    }

    public static boolean isDown(int GLFW_KeyCode) {
        if (GLFW_KeyCode == -1) {
            return false;
        }
        if (GLFW_KeyCode <= 7) {
            return GLFW.glfwGetMouseButton((long)GameKeys.getMainWindow().handle(), (int)GLFW_KeyCode) == 1;
        }
        if (GLFW_KeyCode >= 32 && GLFW_KeyCode <= 348) {
            return GLFW.glfwGetKey((long)GameKeys.getMainWindow().handle(), (int)GLFW_KeyCode) == 1;
        }
        return false;
    }

    public static boolean isAltDown() {
        return InputConstants.isKeyDown((Window)GameKeys.getMainWindow(), (int)342) || InputConstants.isKeyDown((Window)GameKeys.getMainWindow(), (int)346);
    }

    public static KeyMapping createMapping(ResourceLocation actionName, int keyCode, KeyMapping.Category keyCategory) {
        return new KeyMapping(Args.joinDelim(DELIMITER, "keybind", actionName.getNamespace(), actionName.getPath()), keyCode, keyCategory);
    }

    public static enum KeyCategories implements IForgeEnum
    {
        NONE,
        MOVEMENT,
        GAMEPLAY,
        INVENTORY,
        CREATIVE,
        MULTIPLAYER,
        UI,
        MISC;


        @Override
        public String getName() {
            return Args.joinDelim(GameKeys.DELIMITER, GameKeys.KEY, GameKeys.CATEGORIES, IForgeEnum.super.getName());
        }
    }
}

