/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client.renderer;

import com.endertech.minecraft.forge.client.GameRendering;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class GlassMeterIndicatorsRenderer<T>
implements SpecialModelRenderer<T> {
    public static final int DEFAULT_LIGHT = 0xF000F0;
    private static final RenderType RENDER_TYPE = RenderType.entityTranslucent((ResourceLocation)GameRendering.EMPTY_TEXTURE);

    public GlassMeterIndicatorsRenderer(EntityModelSet modelSet) {
    }

    public static void addVertex(VertexConsumer consumer, PoseStack.Pose pose, ColorARGB color, float x, float y, float u, float v) {
        GlassMeterIndicatorsRenderer.addVertex(consumer, pose, color, 0xF000F0, x, y, u, v);
    }

    public static void addVertex(VertexConsumer consumer, PoseStack.Pose pose, ColorARGB color, int packedLight, float x, float y, float u, float v) {
        consumer.addVertex(pose, x, y, 0.0f).setColor(color.getRed().value, color.getGreen().value, color.getBlue().value, color.getAlpha().value).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 0.0f, 1.0f);
    }

    protected RenderType getRenderType() {
        return RENDER_TYPE;
    }
}

