/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.math;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class GameTime {
    public static final int MILLISECONDS_IN_SERVER_TICK = 50;
    public static final CommonTime.IMessure SERVER_TICKS = () -> 50L;
    public static final int TICKS_PER_SECOND = 20;
    protected final CommonTime.Interval interval;
    protected final long ticks;
    protected final int shift;

    public static CommonTime.Interval fromServerTicks(long ticks) {
        return CommonTime.Interval.of(SERVER_TICKS, ticks);
    }

    public static long inServerTicks(CommonTime.Interval time) {
        long ticks = (long)time.in(SERVER_TICKS);
        return ticks;
    }

    protected GameTime(long ticks, int shift) {
        this.interval = GameTime.fromServerTicks(ticks);
        this.ticks = ticks;
        this.shift = shift;
    }

    public static GameTime second() {
        return GameTime.seconds(1);
    }

    public static GameTime halfSecond() {
        return GameTime.ticks(10L);
    }

    public static GameTime quaterSecond() {
        return GameTime.ticks(5L);
    }

    public static GameTime seconds(int seconds) {
        return GameTime.ticks((long)seconds * 20L);
    }

    public static GameTime seconds(float seconds) {
        int ticks = Math.round(seconds * 20.0f);
        return GameTime.ticks(ticks);
    }

    public static GameTime time(CommonTime.Interval time) {
        return GameTime.ticks(GameTime.inServerTicks(time));
    }

    public static GameTime ticks(long ticks, int shift) {
        return new GameTime(ticks, shift);
    }

    public static GameTime ticks(long ticks) {
        return GameTime.ticks(ticks, CommonMath.RANDOM.nextInt());
    }

    protected boolean isPast(long time) {
        return this.ticks == 0L || (time + (long)this.shift) % this.ticks == 0L;
    }

    public boolean pastIn(Level level) {
        return this.isPast(level.getGameTime());
    }

    public boolean pastFor(Entity entity) {
        return this.isPast(entity.tickCount);
    }

    public GameTime noShift() {
        return new GameTime(this.ticks, 0);
    }

    public CommonTime.Interval getInterval() {
        return this.interval;
    }

    public GameTime mult(int multiplier) {
        return GameTime.ticks(this.ticks * (long)multiplier, this.shift);
    }
}

