/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.RandomWrapper;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class Wind
implements IWind,
IHaveConfig {
    public static final FloatBounds STRENGTH_BOUNDS = FloatBounds.between(Float.valueOf(0.0f), Float.valueOf(0.3f));
    protected static final FloatBounds STEP_BOUNDS = FloatBounds.between(Float.valueOf(0.0f), Float.valueOf(0.01f));
    protected static final int SCALE = 100;
    public static final Wind NONE;
    public static Wind defaultWind;
    public static int randomSeed;
    protected final BiomeId biome;
    protected final FloatBounds strengthBounds;
    protected final float changeProbability;
    protected final float changeStep;
    protected final TargetDirection targetDirection;
    protected final GameTime changeInterval = GameTime.second();
    protected final GameTime updateInterval = GameTime.quaterSecond();
    protected Vect3d currentMotion = Vect3d.ZERO;
    protected Vect3d targetMotion = Vect3d.ZERO;
    private final UnitConfig config;

    public Wind(@Nullable UnitConfig config, BiomeId biome, TargetDirection targetDirection, float strengthMax, float changeProbability, float changeStep) {
        this.config = config;
        this.biome = biome;
        String category = this.getClassCategory();
        strengthMax = (float)UnitConfig.getInt(config, category, "maxStrength", Math.round(strengthMax * 100.0f), IntBounds.of(STRENGTH_BOUNDS.scale(100.0f)), "Defines maximum wind strength.") / 100.0f;
        this.strengthBounds = FloatBounds.between(Float.valueOf(-strengthMax), Float.valueOf(strengthMax));
        this.changeProbability = UnitConfig.getFloat(config, category, "changeProbability", changeProbability * 100.0f, GameBounds.PERCENTAGE.getFloatBounds(), "Defines probability of wind strength and direction change in percentage.") / 100.0f;
        this.changeStep = UnitConfig.getFloat(config, category, "changeStep", changeStep * 100.0f, STEP_BOUNDS.scale(100.0f), "Defines how fast the wind changes.") / 100.0f;
        this.targetDirection = UnitConfig.getEnum(config, category, "targetDirection", targetDirection, "Defines the wind direction.\nPossible values: RANDOM, NORTH, SOUTH, WEST, EAST, PLAYER, SPAWN\n");
        this.currentMotion = this.targetMotion = Vect3d.from(this.strengthBounds.randomBetween().floatValue(), 0.0, this.strengthBounds.randomBetween().floatValue());
        this.saveConfig();
    }

    public static void initDefaultWind(AbstractForgeMod mod) {
        UnitConfig config = UnitConfig.in(mod.getConfigsDir(), "Wind");
        randomSeed = config.getInt("Wind", "randomSeed", CommonMath.Random.getInt(), IntBounds.INTEGER, "Random seed");
        defaultWind = new Wind(config, BiomeId.EMPTY, TargetDirection.RANDOM, 0.1f, 0.01f, 0.0015f);
        config.save();
    }

    public static Wind from(UnitConfig config, BiomeId biome) {
        return new Wind(config, biome, TargetDirection.RANDOM, Wind.defaultWind.strengthBounds.getMax().floatValue(), Wind.defaultWind.changeProbability, Wind.defaultWind.changeStep);
    }

    @Override
    public Vect3d getMotion() {
        return this.currentMotion;
    }

    void setCurrentMotion(Vect3d motion) {
        this.currentMotion = motion;
    }

    public TargetDirection getTargetDirection() {
        return this.targetDirection;
    }

    public Vect3d getTargetMotion() {
        return this.targetMotion;
    }

    protected void updateTargetMotion(ServerLevel level) {
        Random random = RandomWrapper.of(level.getRandom());
        this.targetMotion = Vect3d.from(this.strengthBounds.randomBetween(random).floatValue(), 0.0, this.strengthBounds.randomBetween(random).floatValue());
    }

    protected double getChangedMotion(double motion, double targetMotion) {
        double delta = targetMotion - motion;
        if (Math.abs(delta) <= (double)Math.abs(this.changeStep)) {
            return targetMotion;
        }
        double changedMotion = motion;
        if (motion < targetMotion) {
            changedMotion += (double)this.changeStep;
        }
        if (motion > targetMotion) {
            changedMotion -= (double)this.changeStep;
        }
        changedMotion = this.strengthBounds.enclose(Float.valueOf((float)changedMotion)).floatValue();
        return changedMotion;
    }

    public void update(Level level) {
        if (this == NONE) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.changeInterval.pastIn(level) && CommonMath.Random.result(this.changeProbability)) {
                this.updateTargetMotion(serverLevel);
                WindMsg message = new WindMsg(this);
                ForgeEndertech.getInstance().getConnection().sendToAll(message);
            }
        }
        if (this.updateInterval.pastIn(level)) {
            double x = this.getChangedMotion(this.getMotion().x, this.getTargetMotion().x);
            double y = 0.0;
            double z = this.getChangedMotion(this.getMotion().z, this.getTargetMotion().z);
            this.currentMotion = Vect3d.from(x, y, z);
        }
    }

    public IWind getPreciseAt(Level level, BlockPos pos) {
        return switch (this.getTargetDirection().ordinal()) {
            case 1 -> StaticWind.towards(this, Direction.NORTH);
            case 2 -> StaticWind.towards(this, Direction.SOUTH);
            case 3 -> StaticWind.towards(this, Direction.WEST);
            case 4 -> StaticWind.towards(this, Direction.EAST);
            case 5 -> Optional.ofNullable(level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), -1.0, false)).map(player -> StaticWind.between(this, pos, player.blockPosition())).orElse(this);
            case 6 -> StaticWind.between(this, pos, level.getRespawnData().pos());
            default -> this;
        };
    }

    @Override
    @Nullable
    public UnitConfig getConfig() {
        return this.config;
    }

    public boolean equalsDefault() {
        return this.strengthBounds.equals(Wind.defaultWind.strengthBounds) && this.changeProbability == Wind.defaultWind.changeProbability && this.changeStep == Wind.defaultWind.changeStep;
    }

    static {
        defaultWind = NONE = new Wind(null, null, TargetDirection.RANDOM, 0.0f, 0.0f, 0.0f);
        randomSeed = 0;
    }

    public static enum TargetDirection {
        RANDOM,
        NORTH,
        SOUTH,
        WEST,
        EAST,
        PLAYER,
        SPAWN;

    }

    public static class WindMsg
    extends ForgeNetMsg<WindMsg> {
        public String biomeName;
        public TargetDirection targetDirection;
        public Vect3d targetMotion;
        public boolean isDefaultWind;
        public float strengthMax;
        public float changeProbability;
        public float changeStep;

        public WindMsg() {
        }

        public WindMsg(Wind wind) {
            this.biomeName = wind.biome.getResourceLocation().map(ResourceLocation::toString).orElse("");
            this.targetDirection = wind.targetDirection;
            this.targetMotion = wind.targetMotion;
            this.isDefaultWind = wind == defaultWind;
            this.strengthMax = wind.strengthBounds.getMax().floatValue();
            this.changeProbability = wind.changeProbability;
            this.changeStep = wind.changeStep;
        }

        @Override
        public WindMsg create() {
            return new WindMsg();
        }

        @Override
        public void handle(Level level, Player player) {
            BiomeId biome = BiomeId.from(ResourceLocation.parse((String)this.biomeName));
            Wind wind = new Wind(null, biome, this.targetDirection, this.strengthMax, this.changeProbability, this.changeStep);
            wind.targetMotion = this.targetMotion;
            wind.setCurrentMotion(this.targetMotion);
            if (this.isDefaultWind) {
                Vect3d motion = defaultWind.getMotion();
                wind.setCurrentMotion(motion);
                defaultWind = wind;
            } else {
                GameWorld.WorldData data = GameWorld.getData((LevelAccessor)level);
                Wind oldWind = data.biomeWindMap.get(biome);
                if (oldWind != null) {
                    wind.setCurrentMotion(oldWind.getMotion());
                }
                data.biomeWindMap.put(wind.biome, wind);
            }
        }
    }

    public static class StaticWind
    implements IWind {
        private final Vect3d motion;

        public StaticWind(Vect3d motion) {
            this.motion = motion;
        }

        public static StaticWind between(Wind wind, BlockPos source, BlockPos dest) {
            return StaticWind.towards(wind, Vect3d.from(dest).subtract(Vect3d.from(source)));
        }

        public static StaticWind towards(Wind wind, Direction direction) {
            float strength = Mth.abs((float)wind.getStrengthIn(direction));
            return new StaticWind(Vect3d.from(direction.getUnitVec3()).scale(strength));
        }

        public static StaticWind towards(Wind wind, Vect3d direction) {
            Vect3d normalized = direction.withY(0.0).normalize();
            float strength = Mth.abs((float)wind.getStrengthIn(Direction.getApproximateNearest((Vec3)normalized.toVector3d())));
            return new StaticWind(normalized.scale(strength));
        }

        public static StaticWind from(float strength, CommonMath.Angle angle) {
            double x = -angle.sin() * (double)strength;
            double z = angle.cos() * (double)strength;
            Vect3d motion = Vect3d.from(x, 0.0, z);
            return new StaticWind(motion);
        }

        @Override
        public Vect3d getMotion() {
            return this.motion;
        }
    }
}

