/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.math.RandomWrapper;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.config.BlockImpactList;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.impacts.AbstractPollutionImpacts;
import com.endertech.minecraft.mods.adpother.impacts.EnvironmentalImpacts;
import com.endertech.minecraft.mods.adpother.impacts.FluidImpacts;
import com.endertech.minecraft.mods.adpother.init.Fuels;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.PregeneratedClouds;
import com.endertech.minecraft.mods.adpother.pollution.Stats;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import com.google.common.collect.Lists;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class Commands {
    static ServerCommand.Arg<String> pollutantArg() {
        return ServerCommand.Arg.word((String)"pollutant", (context, builder) -> SharedSuggestionProvider.suggest(AdPother.getInstance().pollutants.streamAll().map(Pollutant::getSimpleName), (SuggestionsBuilder)builder));
    }

    static ServerCommand.Arg<String> impactTypeArg() {
        return ServerCommand.Arg.word((String)"type", (context, builder) -> SharedSuggestionProvider.suggest(Stream.of(AbstractPollutionImpacts.ImpactType.values()).map(IForgeEnum::getName), (SuggestionsBuilder)builder));
    }

    public static void chunkStats(ServerCommand.Context context) {
        ServerLevel level = context.getLevel();
        ChunkPollution pollution = WorldData.getChunkPollution((Level)level, context.getBlockPos());
        BiomeId biome = BiomeId.from((LevelAccessor)level, (BlockPos)context.getBlockPos());
        ChunkBounds chunkBounds = ChunkBounds.from((LevelHeightAccessor)level, (ChunkPos)new ChunkPos(context.getBlockPos()));
        context.sendMessage("GasEntities: " + level.getEntitiesOfClass(GasEntity.class, chunkBounds.toAABB(), gas -> true).size());
        AdPother.getInstance().pollutants.streamAll().forEach(pollutant -> context.sendMessage(pollution.getOrCreateInfoFor((Pollutant<?>)((Object)pollutant)).toChatString(biome)));
    }

    public static void worldStats(ServerCommand.Context context) {
        Stats stats = WorldData.getData((Level)context.getLevel()).getStats(ChatFormatting.DARK_AQUA, ChatFormatting.YELLOW);
        for (String string : stats.toList()) {
            context.sendMessage(string);
        }
        context.sendMessage("");
    }

    public static void testTag(ServerCommand.Context context) {
        String tag = (String)context.getArgument("tag", String.class);
        context.sendMessage("Items: " + String.valueOf(TagHelper.getByTag((String)tag, (IForgeRegistry)ForgeRegistries.ITEMS)));
        context.sendMessage("Fluids: " + String.valueOf(TagHelper.getByTag((String)tag, (IForgeRegistry)ForgeRegistries.FLUIDS).stream().map(ForgeBlock::getRegistryName).toList()));
    }

    public static void locateConfigs(ServerCommand.Context context) {
        Util.getPlatform().openFile(AdPother.getInstance().getConfigsDir().toFile());
    }

    public static void loggingFuelConsumption(ServerCommand.Context context) {
        boolean newValue;
        WorldEvents.loggingFuelConsumption = newValue = !WorldEvents.loggingFuelConsumption;
        context.sendMessage("loggingFuelConsumption=" + String.valueOf(ServerCommand.Msg.bool((boolean)newValue)));
    }

    public static void loggingFoodConsumption(ServerCommand.Context context) {
        boolean newValue;
        WorldEvents.loggingFoodConsumption = newValue = !WorldEvents.loggingFoodConsumption;
        context.sendMessage("loggingFoodConsumption=" + String.valueOf(ServerCommand.Msg.bool((boolean)newValue)));
    }

    public static void listBreakables(ServerCommand.Context context) {
        Commands.logListOf("Breakables", AdPother.getInstance().breakables.streamAll().toList(), context);
    }

    public static void listEmitters(ServerCommand.Context context) {
        Commands.logListOf("Emitters", AdPother.getInstance().emitters.streamAll().toList(), context);
    }

    public static void listFuels(ServerCommand.Context context) {
        Commands.logListOf("Fuels", AdPother.getInstance().fuels.streamAll().toList(), context);
    }

    public static void listTorches(ServerCommand.Context context) {
        Commands.logListOf("Torches", AdPother.getInstance().torches.streamAll().toList(), context);
    }

    public static void listFluids(ServerCommand.Context context) {
        Commands.logListOf("Polluting Fluids", ((FluidImpacts)AdPother.getInstance().impacts.fluidImpacts.get()).getAllFluids(), context);
    }

    private static <O> void logListOf(String title, Collection<O> list, ServerCommand.Context context) {
        Logger logger = AdPother.getInstance().getLogger();
        logger.debug(title + "[" + list.size() + "]: {");
        list.stream().map(Objects::toString).forEach(arg_0 -> ((Logger)logger).info(arg_0));
        logger.debug("}");
        context.sendMessage("List of all " + title.toLowerCase() + " was written to .minecraft/logs/debug.log");
    }

    private static void generate(ServerCommand.Context context, IGenerator generator) {
        ServerLevel level = context.getLevel();
        BlockPos pos = context.getBlockPos();
        Pollutant pollutant = Commands.getPollutantByName(context).orElse(null);
        if (pollutant instanceof AbstractGas) {
            AbstractGas gas = (AbstractGas)pollutant;
            ChunkPollution pollution = WorldData.getChunkPollution((Level)level, pos);
            BiomeId biome = BiomeId.from((LevelAccessor)level, (BlockPos)pos);
            int altitude = gas.getConcentrationAltitudeIn(biome);
            int amount = (Integer)context.getArgument("amount", Integer.TYPE);
            Random random = RandomWrapper.of((RandomSource)level.getRandom());
            int count = generator.generate((WorldGenLevel)level, pollution.getLocation().getPos(), altitude, gas, amount, random);
            context.sendMessage("Added " + count + " units of " + String.valueOf(Commands.msgPollutant(pollutant)));
        }
    }

    public static void generateSpots(ServerCommand.Context context) {
        Commands.generate(context, PregeneratedClouds.Generator::generateSpots);
    }

    public static void generateCloud(ServerCommand.Context context) {
        Commands.generate(context, PregeneratedClouds.Generator::generateCloud);
    }

    public static void cleanChunk(ServerCommand.Context context) {
        ServerLevel world = context.getLevel();
        ChunkPos pos = new ChunkPos(context.getBlockPos());
        WorldData.getChunkPollution((Level)world, ChunkLoc.from((Level)world, (ChunkPos)pos)).clean(world);
        context.sendMessage("Chunk at " + String.valueOf(pos) + " cleaned of all pollution");
    }

    public static void cleanChunksAround(ServerCommand.Context context) {
        ServerLevel world = context.getLevel();
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        for (ChunkPos pos : GameWorld.Positions.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            WorldData.getChunkPollution((Level)world, ChunkLoc.from((Level)world, (ChunkPos)pos)).clean(world);
        }
        context.sendMessage("Chunks around " + String.valueOf(centerPos) + " cleaned of all pollution");
    }

    public static void recalcPollutionAtChunk(ServerCommand.Context context) {
        ServerLevel world = context.getLevel();
        ChunkPos pos = new ChunkPos(context.getBlockPos());
        WorldData.getChunkPollution((Level)world, ChunkLoc.from((Level)world, (ChunkPos)pos)).recalculate((Level)world);
        context.sendMessage("Pollution at chunk " + String.valueOf(pos) + " recalculated");
    }

    public static void recalcPollutionAround(ServerCommand.Context context) {
        ServerLevel world = context.getLevel();
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        for (ChunkPos pos : GameWorld.Positions.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            WorldData.getChunkPollution((Level)world, ChunkLoc.from((Level)world, (ChunkPos)pos)).recalculate((Level)world);
        }
        context.sendMessage("Pollution around " + String.valueOf(centerPos) + " recalculated");
    }

    public static void testImpact(ServerCommand.Context context) {
        Pollutant pollutant = Commands.getPollutantByName(context).orElse(null);
        AbstractPollutionImpacts.ImpactType type = Commands.getImpactType(context).orElse(null);
        if (pollutant == null || type == null) {
            return;
        }
        ServerLevel world = context.getLevel();
        BlockHitResult result = context.rayTraceBlockBeingLookedAt(true).orElse(null);
        if (result == null) {
            return;
        }
        BlockPos pos = result.getBlockPos();
        BlockState state = world.getBlockState(pos);
        Optional<Direction> side = Optional.of(result.getDirection());
        EnvironmentalImpacts impacts = (EnvironmentalImpacts)AdPother.getInstance().impacts.environmentalImpacts.get();
        context.sendMessage(String.valueOf(ServerCommand.Msg.unit((String)"Target block", (ChatFormatting)ChatFormatting.GREEN, (UnitId)UnitId.from((BlockState)state))) + (String)(state.getBlock() instanceof BonemealableBlock ? ", type: " + String.valueOf(ServerCommand.Msg.colored((String)"growable", (ChatFormatting)ChatFormatting.AQUA)) : ""));
        context.sendMessage(String.valueOf(Commands.msgPollutant(pollutant)) + " impact(" + Args.join((Object[])Arrays.stream(AbstractPollutionImpacts.ImpactType.values()).map(impact -> impact.getName() + ": " + String.valueOf(Commands.msgActions(impacts.getActionsFor(state, pollutant, (AbstractPollutionImpacts.ImpactType)((Object)impact))))).toArray()) + ")");
        context.sendMessage(String.valueOf(Commands.msgPollutant(pollutant)) + " canPassThrough(from " + String.valueOf(side.get()) + " to " + String.valueOf(side.get().getOpposite()) + "): " + String.valueOf(ServerCommand.Msg.bool((boolean)pollutant.canPassThrough((LevelReader)world, pos, side.get(), side.get().getOpposite()))));
        pollutant.tryAffectBlockAt(world, pos, side, type, pollutant.defaultBlockState());
    }

    public static void emitAt(ServerCommand.Context context) {
        ServerLevel world = context.getLevel();
        BlockHitResult result = context.rayTraceBlockBeingLookedAt(true).orElse(null);
        if (result == null) {
            return;
        }
        Pollutant pollutant = Commands.getPollutantByName(context).orElse(null);
        if (pollutant == null) {
            return;
        }
        BlockPos pos = result.getBlockPos();
        BlockEntity tile = world.getBlockEntity(pos);
        BlockState state = world.getBlockState(pos);
        int quantity = (Integer)context.getArgument("quantity", Integer.TYPE);
        if (tile != null) {
            Set<BlockState> relatedBlocks = AdPother.getInstance().emitters.get(state).map(Emitter::getRelatedBlocks).orElse(Collections.emptySet());
            pollutant.emitFrom(tile, relatedBlocks, quantity);
        } else {
            pollutant.generateAt((WorldGenLevel)world, pos, quantity, 1);
        }
    }

    public static void identifyEmitter(ServerCommand.Context context) {
        Entity entity;
        Emitter emitter;
        Optional info = context.getTargetEntityInfo(false, false, Optional.empty());
        if (info.isPresent() && (emitter = (Emitter)AdPother.getInstance().emitters.get(entity = (Entity)((Pair)info.get()).getKey()).orElse(null)) != null) {
            context.sendMessage(ServerCommand.Msg.emitter((String)((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), (IEmitter)emitter, (boolean)emitter.isActive(INBTSource.of((Entity)entity))));
            return;
        }
        info = context.getTargetBlockInfo(false);
        if (info.isPresent()) {
            BlockPos pos;
            ServerLevel world = context.getLevel();
            Emitter emitter2 = AdPother.getInstance().emitters.get((LevelReader)world, pos = (BlockPos)((Pair)info.get()).getKey()).orElse(null);
            if (emitter2 != null) {
                context.sendMessage(ServerCommand.Msg.emitter((String)((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), (IEmitter)emitter2, (boolean)emitter2.isActive((LevelReader)world, pos)));
                return;
            }
            Torch torch = AdPother.getInstance().torches.get((LevelReader)world, pos).orElse(null);
            if (torch != null) {
                context.sendMessage(ServerCommand.Msg.emitter((String)((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), (IEmitter)torch, (boolean)torch.isActive((LevelReader)world, pos)));
                return;
            }
        }
        context.sendMessage(ServerCommand.Msg.error((String)"No emitter found"));
    }

    private static ServerCommand.Msg msgFuel(String name, Fuel fuel) {
        return ServerCommand.Msg.of((String)(name + " is " + String.valueOf(ServerCommand.Msg.colored((String)fuel.toString(), (ChatFormatting)ChatFormatting.YELLOW))));
    }

    private static ServerCommand.Msg msgActions(List<BlockImpactList.AbstractAction> actions) {
        if (actions.isEmpty()) {
            return ServerCommand.Msg.colored((String)"NONE", (ChatFormatting)ChatFormatting.GRAY);
        }
        return ServerCommand.Msg.of((String)Lists.reverse(actions).stream().map(act -> act.threshold.toColoredText() + String.valueOf(ServerCommand.Msg.colored((String)"->", (ChatFormatting)ChatFormatting.GRAY)) + String.valueOf(ServerCommand.Msg.colored((String)act.type.toString(), (ChatFormatting)act.type.textColor))).collect(Collectors.joining("/")));
    }

    public static void identifyFuel(ServerCommand.Context context) {
        BlockState blockstate;
        BlockPos pos;
        FluidState fluidstate;
        Fuel fuel;
        ServerLevel world = context.getLevel();
        Fuels fuels = AdPother.getInstance().fuels;
        Optional info = context.getTargetFluidInfo(false);
        if (info.isPresent() && (fuel = (Fuel)fuels.get((fluidstate = world.getFluidState(pos = (BlockPos)((Pair)info.get()).getKey())).getType()).orElse(null)) != null) {
            context.sendMessage(Commands.msgFuel(((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), fuel));
            return;
        }
        info = context.getTargetBlockInfo(false);
        if (info.isPresent() && (fuel = (Fuel)fuels.get(blockstate = world.getBlockState(pos = (BlockPos)((Pair)info.get()).getKey())).orElse(null)) != null) {
            context.sendMessage(Commands.msgFuel(((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), fuel));
            return;
        }
        info = context.getHeldItemInfo(InteractionHand.MAIN_HAND, false);
        if (info.isPresent()) {
            BucketItem bucket;
            Item item = (Item)((Pair)info.get()).getKey();
            Fuel fuel2 = fuels.get(item).orElse(null);
            if (fuel2 != null) {
                context.sendMessage(Commands.msgFuel(((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), fuel2));
                return;
            }
            if (item instanceof BucketItem && (fuel2 = (Fuel)fuels.get((bucket = (BucketItem)item).getFluid()).orElse(null)) != null) {
                context.sendMessage(Commands.msgFuel(((ServerCommand.Msg)((Pair)info.get()).getValue()).toString(), fuel2));
                return;
            }
        }
        context.sendMessage(ServerCommand.Msg.error((String)"No fuel found"));
    }

    public static void identifyBlock(ServerCommand.Context context) {
        context.getTargetBlockInfo(true).ifPresent(info -> context.sendMessage((ServerCommand.Msg)info.getValue()));
    }

    public static void identifyTile(ServerCommand.Context context) {
        context.getTargetTileInfo(IEmitter.COMMON_ACTIVE_TAG_NAME, true).ifPresent(info -> context.sendMessage((ServerCommand.Msg)info.getValue()));
    }

    public static void identifyEntity(ServerCommand.Context context) {
        context.getTargetEntityInfo(true, true, Optional.of(IEmitter.COMMON_ACTIVE_TAG_NAME)).ifPresent(info -> context.sendMessage((ServerCommand.Msg)info.getValue()));
    }

    public static void identifyFluid(ServerCommand.Context context) {
        Item item;
        Optional info = context.getTargetFluidInfo(false);
        if (info.isPresent()) {
            context.sendMessage((ServerCommand.Msg)((Pair)info.get()).getValue());
            return;
        }
        info = context.getHeldItemInfo(InteractionHand.MAIN_HAND, false);
        if (info.isPresent() && (item = (Item)((Pair)info.get()).getKey()) instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            Fluid fluid = bucket.getFluid();
            context.sendMessage(String.valueOf(((Pair)info.get()).getValue()) + " contains " + String.valueOf(ServerCommand.Msg.colored((String)UnitId.from((Fluid)fluid, (String)"").toString(), (ChatFormatting)ChatFormatting.AQUA)) + " with tags:" + String.valueOf(ServerCommand.Msg.colored((String)fluid.builtInRegistryHolder().tags().toList().toString(), (ChatFormatting)ChatFormatting.DARK_AQUA)));
            return;
        }
        context.sendMessage(ServerCommand.Msg.error((String)"No fluid found"));
    }

    public static void identifyItem(ServerCommand.Context context) {
        Optional info = context.getHeldItemInfo(InteractionHand.MAIN_HAND, true);
        if (info.isPresent()) {
            int burnTime = context.getLevel().fuelValues().burnDuration(new ItemStack((ItemLike)((Pair)info.get()).getKey()));
            context.sendMessage(Args.join((Object[])new Object[]{((Pair)info.get()).getValue(), ServerCommand.Msg.colored((String)("burnTime: " + burnTime), (ChatFormatting)ChatFormatting.DARK_AQUA), ServerCommand.Msg.colored((String)((double)burnTime / 1600.0 + " of 1xcoal"), (ChatFormatting)ChatFormatting.GRAY)}));
        }
    }

    public static void reloadBiomes(ServerCommand.Context context) {
        WorldData.initBiomeConfigs();
        context.sendMessage("Configs for biomes reloaded");
    }

    public static void reloadBreakables(ServerCommand.Context context) {
        AdPother.getInstance().breakables.reloadConfigs();
        context.sendMessage("Configs for breakables reloaded");
    }

    public static void reloadEmitters(ServerCommand.Context context) {
        WorldData.getData((Level)context.getLevel()).reloadEmitters();
        context.sendMessage("Configs for emitters reloaded");
    }

    public static void reloadFuels(ServerCommand.Context context) {
        AdPother.getInstance().fuels.reloadConfigs();
        context.sendMessage("Configs for fuels reloaded");
    }

    public static void reloadImpacts(ServerCommand.Context context) {
        AdPother.getInstance().impacts.reloadConfigs();
        context.sendMessage("Configs for impacts reloaded");
    }

    public static void reloadSources(ServerCommand.Context context) {
        AdPother.getInstance().sources.reloadConfigs();
        context.sendMessage("Configs for sources reloaded");
    }

    public static void reloadTorches(ServerCommand.Context context) {
        WorldData.getData((Level)context.getLevel()).reloadTorches();
        context.sendMessage("Configs for torches reloaded");
    }

    public static void tickBlock(ServerCommand.Context context) {
        Optional info = context.getTargetBlockInfo(true);
        if (info.isPresent()) {
            ServerLevel world = context.getLevel();
            BlockPos pos = (BlockPos)((Pair)info.get()).getKey();
            BlockState state = world.getBlockState(pos);
            state.randomTick(world, pos, world.random);
            context.sendMessage(String.valueOf(((Pair)info.get()).getValue()) + " randomTick() at " + String.valueOf(pos));
        }
    }

    public static void tickFluid(ServerCommand.Context context) {
        Optional info = context.getTargetFluidInfo(true);
        if (info.isPresent()) {
            ServerLevel world = context.getLevel();
            BlockPos pos = (BlockPos)((Pair)info.get()).getKey();
            FluidState state = world.getFluidState(pos);
            state.randomTick(world, pos, world.random);
            context.sendMessage(String.valueOf(((Pair)info.get()).getValue()) + " randomTick() at " + String.valueOf(pos));
        }
    }

    private static Optional<Pollutant<?>> getPollutantByName(ServerCommand.Context context) {
        String name = (String)context.getArgument("pollutant", String.class);
        Optional<Pollutant<?>> pollutant = AdPother.getInstance().pollutants.findBy(name);
        if (pollutant.isEmpty()) {
            context.sendMessage(ServerCommand.Msg.error((String)"Pollutant with specified name not found!"));
        }
        return pollutant;
    }

    private static Optional<AbstractPollutionImpacts.ImpactType> getImpactType(ServerCommand.Context context) {
        String name = (String)context.getArgument("type", String.class);
        for (AbstractPollutionImpacts.ImpactType type2 : AbstractPollutionImpacts.ImpactType.values()) {
            if (!type2.getName().equalsIgnoreCase(name)) continue;
            return Optional.of(type2);
        }
        context.sendMessage(ServerCommand.Msg.error((String)("Incorrect impact type! Valid values: " + Args.join((Object[])Arrays.stream(AbstractPollutionImpacts.ImpactType.values()).map(type -> type.getName()).toArray()))));
        return Optional.empty();
    }

    private static ServerCommand.Msg msgPollutant(Pollutant<?> pollutant) {
        return ServerCommand.Msg.colored((String)pollutant.getSimpleName(), (ChatFormatting)pollutant.getTextColor());
    }

    @FunctionalInterface
    private static interface IGenerator {
        public int generate(WorldGenLevel var1, ChunkPos var2, int var3, AbstractGas var4, int var5, Random var6);
    }
}

