/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Counters;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.impacts.AbstractPollutionImpacts;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import com.endertech.minecraft.mods.adpother.pollution.PregeneratedClouds;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractGas
extends Pollutant<GasEntity> {
    public static final IntBounds MOVE_DISTANCE = IntBounds.between((Integer)0, (Integer)16);
    public static GameTime spreadIntoWorldInterval = GameTime.seconds((int)3);
    protected final ChunkPollution.Influence.Property<BiomeId> chunkPollutionInfluence;
    private final PregeneratedClouds.Property<BiomeId> pregeneratedClouds;
    private final MultiConfigProperty.BoolProperty<BiomeId> affectedByWind;
    protected final MultiConfigProperty.BoolProperty<BiomeId> dissipateExcessive;
    private final int lowerExplosiveLimit;

    public AbstractGas(UnitConfig config, Properties<?> props) {
        super(config, props, GasEntity.class);
        String category = props.name;
        this.affectedByWind = MultiConfigProperty.BoolProperty.from((UnitConfig)config, (String)category, (String)"affectedByWind", (boolean)props.affectedByWind, (String)"Defines whether wind affects this pollutant or not.");
        this.lowerExplosiveLimit = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"lowerExplosiveLimit", (int)props.lowerExplosiveLimit, (IntBounds)IntBounds.between((Integer)0, (Integer)512), (String)"The lowest number of adjacent gas blocks capable of producing an explosion in the presence of an ignition source.\nSet to zero to disable explosions.");
        this.chunkPollutionInfluence = ChunkPollution.Influence.Property.create(config, category, "chunkPollutionInfluence", props.chunkPollutionInfluence, "Determines when this pollutant affects the pollution level of the chunk it is in.\nPossible values:\n  ALWAYS - always affects regardless of position.\n  CLOUD - affects only when it is part of a cloud at the specified height (see concentrationAltitude).\n  NEVER - never affects chunk pollution level.\n");
        this.pregeneratedClouds = PregeneratedClouds.Property.create(config, category, "pregeneratedClouds", PregeneratedClouds.NONE, "Syntax: minSize-maxSize, rarity, persistence\n  Size (in blocks) - randomly selected between specified bounds for each cloud\n  Rarity (in chunks) - a pollution cloud will be generated once every X chunks\n  Persistence (true/false) - if true, clouds will not gradually dissipate as a result of being affected by underlying blocks or wind\n");
        this.dissipateExcessive = MultiConfigProperty.BoolProperty.from((UnitConfig)config, (String)category, (String)"dissipateExcessive", (boolean)false, (String)"If true, all pollution that exceeds the criticalAmount will gradually dissipate");
        this.addBiomeIdProperties(new MultiConfigProperty.BaseProperty[]{this.affectedByWind, this.chunkPollutionInfluence, this.pregeneratedClouds, this.dissipateExcessive});
    }

    public static boolean isGasBlock(Level world, BlockPos pos) {
        Block block = world.getBlockState(pos).getBlock();
        return block instanceof AbstractGas;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f - (float)this.getCarriedPollutionAmount(state) * 0.1f;
    }

    protected BlockState tryAffectBlocksBelow(ServerLevel level, BlockPos sourcePos, BlockState sourceState) {
        BlockPos underwaterPos;
        BlockState newState;
        BlockPos targetPos = this.getFirstAfterSkippingBlocksBelow((LevelReader)level, sourcePos, BlockBehaviour.BlockStateBase::isAir).orElse(null);
        if (targetPos == null) {
            return sourceState;
        }
        boolean directContact = Math.abs(targetPos.getY() - sourcePos.getY()) <= 1;
        Optional<Direction> side = Optional.of(Direction.UP);
        if (directContact && (newState = this.tryAffectBlockAt(level, targetPos, side, AbstractPollutionImpacts.ImpactType.CONTACT, sourceState)) != sourceState) {
            return newState;
        }
        if (this.isUnderRainOrStorm((LevelAccessor)level, targetPos) && (newState = this.tryAffectBlockAt(level, targetPos, side, AbstractPollutionImpacts.ImpactType.RAIN, sourceState)) != sourceState) {
            return newState;
        }
        newState = this.tryAffectBlockAt(level, targetPos, side, AbstractPollutionImpacts.ImpactType.AIR, sourceState);
        if (newState != sourceState) {
            return newState;
        }
        if (GameWorld.isWaterBlock((LevelReader)level, (BlockPos)targetPos) && (underwaterPos = (BlockPos)this.getFirstAfterSkippingBlocksBelow((LevelReader)level, targetPos, state -> state.isAir() || ForgeBlock.isLiquid((BlockState)state) && state.getFluidState().is(FluidTags.WATER)).orElse(null)) != null) {
            return this.tryAffectBlockAt(level, underwaterPos, side, AbstractPollutionImpacts.ImpactType.AIR, sourceState);
        }
        return sourceState;
    }

    public boolean affectsPollutionLevel(LevelAccessor level, BlockPos pos, BlockState state) {
        BiomeId biome = BiomeId.from((LevelAccessor)level, (BlockPos)pos);
        switch ((ChunkPollution.Influence)((Object)this.chunkPollutionInfluence.get(biome))) {
            case ALWAYS: {
                return true;
            }
            case CLOUD: {
                return this.withinCloudAltitude(level, pos, biome);
            }
            case NEVER: {
                return false;
            }
        }
        return false;
    }

    public boolean canCauseExplosion(LevelAccessor level, BlockPos pos, BlockState state) {
        if (this.getLowerExplosiveLimit() > 0) {
            BiomeId biome = BiomeId.from((LevelAccessor)level, (BlockPos)pos);
            ChunkPollution.Influence affection = (ChunkPollution.Influence)((Object)this.chunkPollutionInfluence.get(BiomeId.from((LevelAccessor)level, (BlockPos)pos)));
            return affection != ChunkPollution.Influence.CLOUD || !this.withinCloudAltitude(level, pos, biome);
        }
        return false;
    }

    protected boolean withinCloudAltitude(LevelAccessor level, BlockPos pos, BiomeId biome) {
        return IntBounds.of((Integer)this.getConcentrationAltitudeIn(biome)).extend(Integer.valueOf(1)).encloses(Integer.valueOf(pos.getY()));
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
    }

    protected <T> List<Supplier<T>> prioritizeOutputSides(Optional<Direction> motionFacing, Supplier<T> top, Supplier<T> side, Supplier<T> bottom) {
        if (motionFacing.isPresent()) {
            switch (motionFacing.get()) {
                case UP: {
                    return Lists.newArrayList((Object[])new Supplier[]{top, side, bottom});
                }
                case DOWN: {
                    return Lists.newArrayList((Object[])new Supplier[]{bottom, side, top});
                }
            }
        }
        return CommonMath.Random.getBoolean() ? Lists.newArrayList((Object[])new Supplier[]{side, top, bottom}) : Lists.newArrayList((Object[])new Supplier[]{side, bottom, top});
    }

    @Override
    public int emitFrom(BlockEntity tile, Set<BlockState> relatedBlocks, int amount) {
        Level level = tile.getLevel();
        if (level == null || amount <= 0 || level.isClientSide()) {
            return 0;
        }
        Counters.IntCounter counter = Counters.fromZeroTo((int)amount);
        BlockPos sourcePos = tile.getBlockPos();
        Optional<Direction> motionFacing = this.getMotionFacing((LevelAccessor)level, sourcePos);
        WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((BlockEntity)tile, relatedBlocks);
        this.prioritizeOutputSides(motionFacing, () -> neighbors.getTopActivePumps(0), () -> ((WorldSearch.TileNeighbors)neighbors).getSideActivePumps(), () -> ((WorldSearch.TileNeighbors)neighbors).getBottomActivePumps()).forEach(pumps -> this.tryPumpThrough((Supplier<List<BlockPos>>)pumps, (LevelAccessor)level, counter));
        if (motionFacing.isPresent() && motionFacing.get() == Direction.UP) {
            this.tryPumpRandomAt(() -> neighbors.getTopPassableChimneys(0), (LevelAccessor)level, counter, (lev, pos) -> true);
            this.tryPumpRandomAt(() -> neighbors.getSidePassableChimneys(), (LevelAccessor)level, counter, (lev, pos) -> true);
            this.tryPumpRandomAt(() -> neighbors.getTopPipeOutlets(false, GameWorld.SmokeContainers::hasWayOut), (LevelAccessor)level, counter, (lev, pos) -> true);
        }
        BiPredicate<LevelAccessor, BlockPos> condition = (lev, pos) -> {
            BlockPos vec = sourcePos.subtract((Vec3i)pos);
            Direction dir = Direction.getApproximateNearest((float)vec.getX(), (float)vec.getY(), (float)vec.getZ());
            return this.canPassThrough((LevelReader)lev, (BlockPos)pos, dir, dir) && !neighbors.isMultiblockHollow(pos);
        };
        this.prioritizeOutputSides(motionFacing, () -> ((WorldSearch.TileNeighbors)neighbors).getAboveBlocks(), () -> ((WorldSearch.TileNeighbors)neighbors).getSideBlocks(), () -> ((WorldSearch.TileNeighbors)neighbors).getUnderBlocks()).forEach(positions -> this.tryPumpRandomAt((Supplier<List<BlockPos>>)positions, (LevelAccessor)level, counter, condition));
        return counter.getValue();
    }

    protected void tryPumpThrough(Supplier<List<BlockPos>> pumps, LevelAccessor level, Counters.IntCounter counter) {
        if (counter.canIncrement()) {
            int count = GameWorld.SmokeContainers.pumpPollutionThrough(pumps.get(), (LevelAccessor)level, (IPollutant)this, (int)counter.getDistToMaximum());
            counter.add(count);
        }
    }

    protected void tryPumpRandomAt(Supplier<List<BlockPos>> positions, LevelAccessor level, Counters.IntCounter counter, BiPredicate<LevelAccessor, BlockPos> condition) {
        if (counter.canIncrement()) {
            List<BlockPos> shuffled = positions.get();
            Collections.shuffle(shuffled);
            for (BlockPos pos : shuffled) {
                if (condition.test(level, pos)) {
                    int count = this.pumpEntitiesAt(level, pos, counter.getDistToMaximum());
                    counter.add(count);
                }
                if (!counter.atMax()) continue;
                return;
            }
        }
    }

    public boolean canPassThrough(LevelReader level, BlockPos pos, Direction input, Direction output) {
        ISmokeContainer container;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof AbstractGas || this.isSamePollutant(state)) {
            return false;
        }
        if (block == Blocks.AIR || block == Blocks.FIRE) {
            return true;
        }
        if (block instanceof FenceBlock || block instanceof FenceGateBlock) {
            return true;
        }
        if (block instanceof IronBarsBlock && !(block instanceof StainedGlassPaneBlock)) {
            return true;
        }
        if (block instanceof ISmokeContainer && (container = (ISmokeContainer)block).isVent() && input.getAxis().isHorizontal() && output.getAxis().isHorizontal()) {
            return true;
        }
        if (block instanceof LiquidBlock) {
            return true;
        }
        if (state.isAir() || state.is(BlockTags.LEAVES) || state.is(BlockTags.FIRE)) {
            return true;
        }
        if (this.passableBlocks.contains(state)) {
            return true;
        }
        if (GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)pos)) {
            if (input.getAxis().isVertical() && output.getAxis().isVertical()) {
                return true;
            }
            if ((input.getAxis().isHorizontal() || output.getAxis().isHorizontal()) && (input == output || input.getAxis().isVertical() || output.getAxis().isVertical())) {
                if (block instanceof ISmokeContainer && (container = (ISmokeContainer)block).isChimney()) {
                    if (input.getAxis().isHorizontal() && this.pipeWithoutWall(state, input)) {
                        return true;
                    }
                    return output.getAxis().isHorizontal() && this.pipeWithoutWall(state, output);
                }
                if (state.isFaceSturdy((BlockGetter)level, pos, Direction.DOWN, SupportType.CENTER) && state.isFaceSturdy((BlockGetter)level, pos, Direction.UP, SupportType.CENTER)) {
                    return false;
                }
            }
        }
        for (Direction direction : new Direction[]{input, output}) {
            if (!state.isFaceSturdy((BlockGetter)level, pos, direction)) continue;
            return false;
        }
        return true;
    }

    protected boolean pipeWithoutWall(BlockState state, Direction facing) {
        BooleanProperty property = (BooleanProperty)PipeBlock.PROPERTY_BY_DIRECTION.get(facing);
        return property != null && state.hasProperty((Property)property) && (Boolean)state.getValue((Property)property) == false;
    }

    @Override
    public Map<ItemStack, IStorageItem> getProtectiveItems(LivingEntity living) {
        HashMap<ItemStack, IStorageItem> items = new HashMap<ItemStack, IStorageItem>();
        for (ItemStack stack : ForgeEntity.getEquipmentOn((Entity)living)) {
            IStorage.Content content;
            Respirators.Respirator respirator = AdPother.getInstance().respirators.get(stack).orElse(null);
            if (respirator == null || !respirator.isFunctional(stack) || ForgeEntity.isEating((LivingEntity)living) || (content = respirator.getContent(stack)).getFreeSpaceFor(this) <= 0) continue;
            items.put(stack, respirator);
        }
        return items;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return false;
    }

    public void onBlockExploded(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion) {
    }

    protected void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean moving) {
        BlockState newState = level.getBlockState(pos);
        if (!(newState.is((Block)this) || newState.isAir() || newState.getBlock() instanceof LiquidBlock)) {
            BlockPos movePos;
            int amount = this.getCarriedPollutionAmount(state);
            List movePositions = GameWorld.Positions.getAroundCube((BlockPos)pos);
            Collections.shuffle(movePositions);
            int count = 0;
            Iterator iterator = movePositions.iterator();
            while (iterator.hasNext() && (count += this.pump((LevelAccessor)level, movePos = (BlockPos)iterator.next(), amount - count)) < amount) {
            }
        }
        super.affectNeighborsAfterRemoval(state, level, pos, moving);
    }

    @Override
    public Spread createSpread(ServerLevel level, final BlockPos pos, final BlockState state) {
        return new Spread(level, pos, state, this){

            @Override
            public Spread around(int minDensityDelta) {
                block1: {
                    Direction dir;
                    if (this.completed() || !AbstractGas.this.canSpreadAround() || this.pollutant.getCarriedPollutionAmount(state) < minDensityDelta) break block1;
                    IWind wind = GameWorld.getWindAt((Level)this.level, (BlockPos)pos);
                    List directions = GameWorld.Directions.of().horizontals().shuffle().toList();
                    wind.sortDirections(directions);
                    Iterator iterator = directions.iterator();
                    while (iterator.hasNext() && !this.in(dir = (Direction)iterator.next(), minDensityDelta).completed()) {
                    }
                }
                return this;
            }
        };
    }

    public boolean pushedBy(ServerLevel world, BlockPos pos, Player player, Direction face) {
        if (!GameWorld.isServerSide((LevelReader)world)) {
            return false;
        }
        Block block = world.getBlockState(pos).getBlock();
        float probability = 0.2f;
        if (!CommonMath.Random.result((float)probability)) {
            return false;
        }
        AbstractGas pollutant = (AbstractGas)block;
        ArrayList<Direction> directions = new ArrayList<Direction>(){
            private static final long serialVersionUID = -3415775606148431593L;

            @Override
            public boolean add(Direction e) {
                if (this.contains(e)) {
                    return false;
                }
                return super.add(e);
            }
        };
        directions.add(face.getOpposite());
        Direction sourceDir = Direction.orderedByNearest((Entity)player)[0];
        Direction pushDir = sourceDir.getOpposite();
        directions.add(pushDir);
        Optional<Direction> motionFacing = pollutant.getMotionFacing((LevelAccessor)world, pos);
        motionFacing.ifPresent(directions::add);
        directions.addAll(GameWorld.Directions.of().all().shuffle().toList());
        if (motionFacing.isPresent()) {
            Direction opposite = motionFacing.get().getOpposite();
            directions.remove(opposite);
            directions.add(opposite);
        }
        directions.remove(sourceDir);
        directions.add(sourceDir);
        for (Direction dir : directions) {
            if (!pollutant.push((LevelAccessor)world, pos, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected GasEntity createEntityPollutant(ServerLevel level, BlockPos pos, BlockState carriedState) {
        return new GasEntity((Level)level, pos, carriedState);
    }

    @Override
    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return true;
    }

    protected Optional<BlockPos> getFirstAfterSkippingBlocksBelow(LevelReader level, BlockPos startPos, Predicate<BlockState> skip) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos().set((Vec3i)startPos.below());
        int minY = Math.max(pos.getY() - 256, WorldData.altitudeBounds.getMin());
        for (int y = pos.getY(); y >= minY; --y) {
            pos.setY(y);
            BlockState state = level.getBlockState((BlockPos)pos);
            if (skip.test(state)) continue;
            return Optional.of(pos.immutable());
        }
        return Optional.empty();
    }

    protected boolean isPersistentCloud(LevelAccessor level, BlockPos pos, BiomeId biome) {
        PregeneratedClouds.Data data = this.getPregeneratedCloudsData(biome);
        return data.persistence() && this.withinCloudAltitude(level, pos, biome);
    }

    public void randomTick(BlockState sourceState, ServerLevel level, BlockPos sourcePos, RandomSource random) {
        if (level.isClientSide() || !this.inAllowableDimension(level)) {
            return;
        }
        BiomeId biome = BiomeId.from((LevelAccessor)level, (BlockPos)sourcePos);
        if (this.shouldDissipateExcessive(level, sourcePos, biome)) {
            this.spend((LevelAccessor)level, sourcePos);
            return;
        }
        BlockState newSourceState = this.tryAffectBlocksBelow(level, sourcePos, sourceState);
        if (newSourceState != sourceState) {
            if (!this.isPersistentCloud((LevelAccessor)level, sourcePos, biome)) {
                level.setBlockAndUpdate(sourcePos, newSourceState);
            }
            return;
        }
        if (this.pushedByWind((Level)level, sourcePos, sourceState)) {
            return;
        }
        if (!this.withinCloudAltitude((LevelAccessor)level, sourcePos, biome)) {
            this.tick(sourceState, level, sourcePos, random);
        }
    }

    @Override
    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        for (BlockPos checkpos : GameWorld.Positions.getAroundCube((BlockPos)pos)) {
            if (!WorldData.isIgnitionSource((Level)level, checkpos)) continue;
            if (!GasExplosion.in((LevelAccessor)level).position(pos).tryExplode()) break;
            return;
        }
        super.tick(state, level, pos, rand);
    }

    protected boolean pushedByWind(Level level, BlockPos sourcePos, BlockState sourceState) {
        if (!this.canBeAffectedByWind((LevelAccessor)level, sourcePos, BiomeId.from((LevelAccessor)level, (BlockPos)sourcePos))) {
            return false;
        }
        IWind wind = GameWorld.getWindAt((Level)level, (BlockPos)sourcePos);
        List directions = GameWorld.Directions.of().horizontals().shuffle().toList();
        wind.sortDirections(directions);
        for (Direction direction : directions) {
            BlockPos pos;
            float strength = wind.getStrengthIn(direction);
            if (!(strength > 0.0f)) continue;
            float factor = Wind.STRENGTH_BOUNDS.encloses(Float.valueOf(strength)) ? Wind.STRENGTH_BOUNDS.interpolationFactor(Float.valueOf(strength)) : strength;
            int maxDistance = CommonMath.Interpolation.up((float)factor, (IntBounds)MOVE_DISTANCE);
            BlockPos destPos = null;
            for (int offset = 1; offset <= maxDistance && GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)(pos = sourcePos.relative(direction, offset))) && GameWorld.isAirBlock((LevelReader)level, (BlockPos)pos); ++offset) {
                destPos = pos;
            }
            if (destPos == null || !this.pump((LevelAccessor)level, destPos)) continue;
            return this.spend((LevelAccessor)level, sourcePos);
        }
        return false;
    }

    public IPollutant.Type getPollutantType() {
        return IPollutant.Type.AIR;
    }

    public int getLowerExplosiveLimit() {
        return this.lowerExplosiveLimit;
    }

    public boolean canBeAffectedByWind(LevelAccessor level, BlockPos pos, BiomeId biome) {
        return (Boolean)this.affectedByWind.get((Object)biome) != false && !this.isPersistentCloud(level, pos, biome);
    }

    public ChunkPollution.Influence getChunkPollutionInfluence(BiomeId biome) {
        return (ChunkPollution.Influence)((Object)this.chunkPollutionInfluence.get(biome));
    }

    public PregeneratedClouds.Data getPregeneratedCloudsData(BiomeId biome) {
        return (PregeneratedClouds.Data)this.pregeneratedClouds.get(biome);
    }

    public boolean shouldDissipateExcessive(ServerLevel level, BlockPos pos, BiomeId biome) {
        if (((Boolean)this.dissipateExcessive.get((Object)biome)).booleanValue() && !this.isPersistentCloud((LevelAccessor)level, pos, biome)) {
            PollutionInfo info = WorldData.getChunkPollution((Level)level, pos).getOrCreateInfoFor(this);
            return info.getQuantity() > info.getCriticalAmountIn(biome);
        }
        return false;
    }

    public static class Properties<T extends Properties<T>>
    extends Pollutant.Properties<T> {
        public int absorbtionChance = 0;
        public int lowerExplosiveLimit = 0;
        public ChunkPollution.Influence chunkPollutionInfluence = ChunkPollution.Influence.CLOUD;
        public boolean affectedByWind = true;

        public static Properties<?> of(ResourceKey<Block> blockId, MapColor color) {
            return new Properties<Properties>(Properties.class, blockId, color);
        }

        protected Properties(Class<T> selfClass, ResourceKey<Block> blockId, MapColor color) {
            super(selfClass, blockId, color);
            this.vanillaProps.noCollision().noOcclusion().noTerrainParticles().pushReaction(PushReaction.PUSH_ONLY).randomTicks().replaceable().instabreak().isViewBlocking((s, w, p) -> false).isSuffocating((s, w, p) -> true);
        }

        public T absorbtionChance(int percentage) {
            this.absorbtionChance = percentage;
            return (T)((Object)((Properties)this.self));
        }

        public T lowerExplosiveLimit(int limit) {
            this.lowerExplosiveLimit = limit;
            return (T)((Object)((Properties)this.self));
        }

        public T ignoreWind() {
            this.affectedByWind = false;
            return (T)((Object)((Properties)this.self));
        }

        public T neverAffectChunkPollution() {
            this.chunkPollutionInfluence = ChunkPollution.Influence.NEVER;
            return (T)((Object)((Properties)this.self));
        }

        public T alwaysAffectChunkPollution() {
            this.chunkPollutionInfluence = ChunkPollution.Influence.ALWAYS;
            return (T)((Object)((Properties)this.self));
        }
    }
}

