/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public final class DynamicTrees {
    private static final Lazy<Optional<DynamicTrees>> INSTANCE = AbstractForgeMod.singletonInstance((String)"dynamictrees", DynamicTrees.class);
    private final Class<?> classTreePart;
    private final Method findRootNode;
    private final Method growPulse;
    private final Method getBranch;
    private final Method getLeaves;
    private final Method leaves$age;
    private final Field bounds$ANY;

    public static Optional<DynamicTrees> getInstance() {
        return (Optional)INSTANCE.get();
    }

    private DynamicTrees() throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        Class<?> treeHelper = Class.forName("com.ferreusveritas.dynamictrees.api.TreeHelper");
        Class<?> dynamicLeavesBlock = Class.forName("com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock");
        Class<?> safeChunkBounds = Class.forName("com.ferreusveritas.dynamictrees.util.SafeChunkBounds");
        this.classTreePart = Class.forName("com.ferreusveritas.dynamictrees.api.treedata.TreePart");
        this.findRootNode = treeHelper.getMethod("findRootNode", Level.class, BlockPos.class);
        this.growPulse = treeHelper.getMethod("growPulse", Level.class, BlockPos.class);
        this.getBranch = treeHelper.getMethod("getBranch", BlockState.class);
        this.getLeaves = treeHelper.getMethod("getLeaves", BlockState.class);
        this.leaves$age = dynamicLeavesBlock.getMethod("age", LevelAccessor.class, BlockPos.class, BlockState.class, RandomSource.class, safeChunkBounds);
        this.bounds$ANY = safeChunkBounds.getField("ANY");
    }

    public void tryGrow(ServerLevel level, BlockPos startPos, BlockState state) {
        try {
            if (!this.classTreePart.isInstance(state.getBlock())) {
                return;
            }
            BlockPos branchPos = this.findBranchUnderLeaves(level, startPos).orElse(null);
            if (branchPos != null) {
                BlockPos rootPos = (BlockPos)this.findRootNode.invoke(null, level, branchPos);
                if (rootPos != BlockPos.ZERO) {
                    this.growPulse.invoke(null, level, rootPos);
                }
            } else {
                Object leaves = this.getLeaves.invoke(null, state);
                if (leaves != null) {
                    this.leaves$age.invoke(leaves, level, startPos, state, level.random, this.bounds$ANY.get(null));
                }
            }
        }
        catch (Exception e) {
            ForgeEndertech.debugMsg((String)e.toString());
        }
    }

    public Optional<BlockPos> findBranchUnderLeaves(ServerLevel level, BlockPos startPos) {
        try {
            int offset = 0;
            while (true) {
                BlockPos pos = startPos.relative(Direction.DOWN, offset);
                BlockState state = level.getBlockState(pos);
                if (this.getBranch.invoke(null, state) != null) {
                    return Optional.of(pos);
                }
                if (this.getLeaves.invoke(null, state) != null) {
                    ++offset;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ForgeEndertech.debugMsg((String)e.toString());
        }
        return Optional.empty();
    }
}

