/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.EmitterWithCustomRate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;

public class TrajansTanks {
    public static ForgeConfigSpec.ConfigValue<Double> rate;

    public static class FuelConsumedMsg
    extends ForgeNetMsg<FuelConsumedMsg> {
        public int entityId = 0;
        public int consumed = 0;

        public FuelConsumedMsg() {
        }

        public FuelConsumedMsg(Entity entity, int consumed) {
            this.entityId = entity.getId();
            this.consumed = consumed;
        }

        public FuelConsumedMsg create() {
            return new FuelConsumedMsg();
        }

        public void sendToServer() {
            AdPother.getInstance().getConnection().sendToServer((Object)this);
        }

        public void handle(Level level, Player player) {
            if (level.isClientSide()) {
                return;
            }
            Entity entity = level.getEntity(this.entityId);
            if (entity == null) {
                return;
            }
            AdPother.getInstance().emitters.get(entity).ifPresent(emitter -> {
                BlockPos pos = BlockPos.containing((Position)WorldEvents.Alignment.BACK.getPositionVec(entity));
                emitter.emitAt(entity.level(), pos, this.consumed);
            });
        }
    }

    public static class Tank
    extends EmitterWithCustomRate {
        public static Emitter.Properties<?> properties(String name) {
            float coalPerSecond = 0.16666667f;
            float perTick = coalPerSecond / 20.0f;
            return ((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)((Object)((Emitter.Properties)((Emitter.Properties)((Object)Emitter.Properties.with(IEmitter.Type.FUEL).factor(perTick))).activeTag("fuel").id("trajanstanks:" + name + "_entity_type")).carbon(1.0f))).sulfur(0.1f))).dust(4.0f))).customFactory(Tank::new);
        }

        public static final void onFuelBurned(Entity entity, int amount) {
            if (amount > 0 && entity.level().isClientSide()) {
                new FuelConsumedMsg(entity, amount).sendToServer();
            }
        }

        public Tank(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        @Override
        protected float getRate() {
            return ((Double)rate.get()).floatValue();
        }

        public boolean isActive(INBTSource<?> nbtSource) {
            boolean isVehicle = nbtSource.source().filter(Entity.class::isInstance).map(Entity.class::cast).map(Entity::isVehicle).orElse(false);
            return isVehicle && super.isActive(nbtSource);
        }
    }
}

