/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.entities;

import com.endertech.common.FloatBounds;
import com.endertech.common.IBounds;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.AABBHelper;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.FilterFrame;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class PurifiedAir
extends ForgeEntity {
    protected static final EntityDataAccessor<Boolean> FADING = SynchedEntityData.defineId(PurifiedAir.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected final GameTime checkSourceInterval = GameTime.second();
    protected Block pollutant;
    protected BlockPos filterPos;
    protected Block filter;
    protected Percentage concentration;

    public PurifiedAir(EntityType<?> type, Level world) {
        super(type, world);
    }

    public PurifiedAir(Level world, BlockPos pos, Pollutant<?> pollutant, BlockPos filterPos) {
        this((EntityType)AdPother.getInstance().entities.purifiedAir.get(), world);
        this.pollutant = pollutant;
        this.filterPos = filterPos;
        this.filter = world.getBlockState(filterPos).getBlock();
        this.concentration = Percentage.ZERO;
        Vect3d centeredPos = PurifiedAir.getCenteredPosTo((BlockPos)pos);
        this.setAllPositions(centeredPos);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(FADING, (Object)false);
    }

    public static List<PurifiedAir> getAllAt(Level world, BlockPos pos) {
        AABB aabb = AABBHelper.BLOCK.move(pos);
        return world.getEntitiesOfClass(PurifiedAir.class, aabb);
    }

    public Optional<Pollutant<?>> getPollutant() {
        return this.pollutant instanceof Pollutant ? Optional.of((Pollutant)this.pollutant) : Optional.empty();
    }

    public boolean isAttackable() {
        return false;
    }

    public void tick() {
        if (this.isServerSide()) {
            this.onServerTick();
        } else {
            this.onClientTick();
        }
    }

    protected void onClientTick() {
    }

    protected void onServerTick() {
        if (!this.getPollutant().isPresent() || !this.getFilter().isPresent()) {
            this.discard();
            return;
        }
        boolean fading = (Boolean)this.getEntityData().get(FADING);
        FloatBounds percentage = GameBounds.PERCENTAGE.getFloatBounds();
        int signum = fading ? -1 : 1;
        float speed = 0.2f;
        float value = percentage.enclose(Float.valueOf(this.concentration.getValue() + (float)signum * speed)).floatValue();
        this.concentration = Percentage.value((float)value);
        if (fading && this.concentration.getValue() <= percentage.getMin().floatValue()) {
            this.discard();
            return;
        }
        if (!this.checkSourceInterval.pastIn(this.level())) {
            return;
        }
        boolean renewable = this.hasFilterProperMaterial() && this.isPurifierActive();
        this.getEntityData().set(FADING, (Object)(!renewable ? 1 : 0));
    }

    protected boolean hasFilterProperMaterial() {
        return this.getFilter().flatMap(filter -> filter.getTile((BlockGetter)this.level(), this.filterPos)).map(tile -> tile.getTargetPollutants().contains(this.pollutant)).orElse(false);
    }

    protected boolean isPurifierActive() {
        return this.getPurifier().map(purifier -> purifier.getOutputPos((LevelReader)this.level(), this.filterPos).equals((Object)this.blockPosition()) && purifier.isActive((LevelReader)this.level(), this.filterPos)).orElse(false);
    }

    public Percentage getConcentrationAt(Vec3 position) {
        FilterFrame.AirPurifier purifier = this.getPurifier().orElse(null);
        if (purifier == null) {
            return Percentage.ZERO;
        }
        double distance = this.position().distanceTo(position);
        if (distance <= (double)purifier.effectiveRadius) {
            return this.concentration;
        }
        if (distance > (double)purifier.maximumRadius) {
            return Percentage.ZERO;
        }
        float value = ((Float)FloatBounds.between((Float)Float.valueOf(purifier.effectiveRadius), (Float)Float.valueOf(purifier.maximumRadius)).interpolateTo((IBounds)FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(this.concentration.getValue()))).backward((Number)Float.valueOf((float)distance))).floatValue();
        return Percentage.value((float)value);
    }

    public void startFading() {
        this.getEntityData().set(FADING, (Object)true);
    }

    public Optional<FilterFrame.AirPurifier> getPurifier() {
        return this.getFilter().map(FilterFrame::getAirPurifier);
    }

    public Optional<FilterFrame> getFilter() {
        return this.filter instanceof FilterFrame ? Optional.of((FilterFrame)this.filter) : Optional.empty();
    }

    protected void readAdditionalSaveData(ValueInput input) {
        this.pollutant = input.getString("pollutant").map(ResourceLocation::tryParse).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getValue(arg_0)).orElse(Blocks.AIR);
        this.filter = input.getString("filter").map(ResourceLocation::tryParse).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getValue(arg_0)).orElse(Blocks.AIR);
        this.filterPos = BlockPos.of((long)input.getLongOr("filterPos", 0L));
        this.concentration = Percentage.value((float)input.getFloatOr("concentration", 0.0f));
        this.entityData.set(FADING, (Object)input.getBooleanOr("fading", false));
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        output.putString("pollutant", ForgeBlock.getRegistryName((Block)this.pollutant).toString());
        output.putString("filter", ForgeBlock.getRegistryName((Block)this.filter).toString());
        output.putLong("filterPos", this.filterPos.asLong());
        output.putFloat("concentration", this.concentration.getValue());
        output.putBoolean("fading", ((Boolean)this.entityData.get(FADING)).booleanValue());
    }
}

