/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.impacts.AbstractPollutionImpacts;
import com.endertech.minecraft.mods.adpother.impacts.FluidImpacts;
import com.endertech.minecraft.mods.adpother.impacts.LivingImpacts;
import com.endertech.minecraft.mods.adpother.init.Sources;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.AnimalBurning;
import com.endertech.minecraft.mods.adpother.sources.AnimalDying;
import com.endertech.minecraft.mods.adpother.sources.AnimalFeeding;
import com.endertech.minecraft.mods.adpother.sources.HostileMobBurning;
import com.endertech.minecraft.mods.adpother.sources.HostileMobDying;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="adpother")
public class EntityEvents {
    static final GameTime UPDATE_INTERVAL = GameTime.second();

    @SubscribeEvent
    public static void onLivingEntityUpdate(LivingEvent.LivingTickEvent event) {
        ServerLevel level;
        LivingEntity living;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof LivingEntity && (livingEntity = (living = livingEntity).level()) instanceof ServerLevel && UPDATE_INTERVAL.pastIn((Level)(level = (ServerLevel)livingEntity))) {
            EntityPollution pollution = WorldData.getEntityPollution((Entity)living);
            int combinedDamage = pollution.getInfos().map(PollutionInfo::getPollutant).mapToInt(pollutant -> {
                int damage = pollution.getDamageFrom((Pollutant<?>)((Object)pollutant));
                Map<ItemStack, IStorageItem> protectItems = pollutant.getProtectiveItems(living);
                if (protectItems.isEmpty()) {
                    if (!EntityEvents.killWeakLiving(living, damage)) {
                        AbstractPollutionImpacts.ImpactType impact = pollution.getImpactType((Pollutant<?>)((Object)pollutant));
                        Percentage influence = pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant));
                        pollutant.tryAffectEntity((Entity)living, impact, influence);
                    }
                } else {
                    protectItems.forEach((stack, item) -> item.fill(stack, (Pollutant<?>)((Object)pollutant), damage));
                }
                return damage;
            }).sum();
            AdPother.getInstance().respirators.updateEffectFor(living, combinedDamage);
        }
    }

    static boolean killWeakLiving(LivingEntity living, int damage) {
        if (ForgeEntity.isHostileMob((Entity)living)) {
            return false;
        }
        float health = living.getHealth();
        if (ForgeEntity.isServerSide((Entity)living) && health <= (float)damage && !(living instanceof Player)) {
            living.hurt(living.damageSources().wither(), (float)damage);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onCreatureJoinWorld(EntityJoinLevelEvent event) {
        PathfinderMob creature = EntityEvents.getServerEntityOf(PathfinderMob.class, (EntityEvent)event).orElse(null);
        if (creature == null) {
            return;
        }
        if (ForgeEntity.isHostileMob((Entity)creature)) {
            return;
        }
        if (creature instanceof AgeableMob) {
            EntityPollution pollution = WorldData.getEntityPollution((Entity)creature);
            pollution.getPollutants().filter(pollutant -> ((LivingImpacts)AdPother.getInstance().impacts.livingImpacts.get()).getActiveEffectsFor((Entity)creature, (Pollutant<?>)((Object)pollutant), AbstractPollutionImpacts.ImpactType.AIR, pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant))).stream().anyMatch(entityEffect -> ((MobEffect)entityEffect.effect.get()).getCategory() == MobEffectCategory.HARMFUL)).max(Comparator.comparing(pollution::getInfluenceOf)).ifPresent(pollutant -> {
                float factor = pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant)).toFraction();
                Optional.ofNullable(creature.getAttribute(Attributes.MAX_HEALTH)).ifPresent(attribute -> {
                    double baseHealth = attribute.getBaseValue();
                    int newHealth = IntBounds.between((Integer)1, (Integer)((int)baseHealth)).interpolateDown(factor);
                    attribute.setBaseValue((double)newHealth);
                });
            });
        }
    }

    @SubscribeEvent
    public static void onCreatureSpawnCheck(MobSpawnEvent.PositionCheck event) {
        BlockPos pos;
        ServerLevelAccessor level;
        Optional<WaterAnimal> animal = EntityEvents.getServerEntityOf(WaterAnimal.class, (EntityEvent)event);
        if (animal.isPresent() && GameWorld.isBlockLoaded((LevelReader)(level = event.getLevel()), (BlockPos)(pos = BlockPos.containing((double)event.getX(), (double)event.getY(), (double)event.getZ()))) && ((FluidImpacts)AdPother.getInstance().impacts.fluidImpacts.get()).findPollutingFluidInWaterAtPosOrAbove(level, pos).isPresent()) {
            event.setResult(Result.DENY);
        }
    }

    static <T extends Entity> Optional<T> getServerEntityOf(Class<T> clazz, EntityEvent event) {
        Entity entity = event.getEntity();
        if (clazz.isInstance(entity) && entity.level() instanceof ServerLevel) {
            return Optional.of((Entity)clazz.cast(entity));
        }
        return Optional.empty();
    }

    @SubscribeEvent(priority=-127)
    public static void onLivingHeal(LivingHealEvent event) {
        EntityEvents.getServerEntityOf(Animal.class, (EntityEvent)event).ifPresent(animal -> {
            float health = animal.getHealth();
            if (health < animal.getMaxHealth() && health + event.getAmount() >= animal.getMaxHealth()) {
                ((AnimalFeeding)((Object)((Object)AdPother.getInstance().sources.animalFeeding.get()))).emitFrom(animal, 1.0f);
            }
        });
    }

    @SubscribeEvent(priority=-127)
    public static void onLivingDeath(LivingDeathEvent event) {
        Sources sources = AdPother.getInstance().sources;
        if (event.getSource().is(DamageTypeTags.IS_FIRE)) {
            EntityEvents.getServerEntityOf(Mob.class, (EntityEvent)event).ifPresent(living -> {
                if (ForgeEntity.isHostileMob((Entity)living)) {
                    ((HostileMobBurning)((Object)((Object)sources.hostileMobBurning.get()))).emitFrom(living, 1.0f);
                } else {
                    ((AnimalBurning)((Object)((Object)sources.animalBurning.get()))).emitFrom(living, 1.0f);
                }
            });
        } else {
            EntityEvents.getServerEntityOf(Mob.class, (EntityEvent)event).ifPresent(living -> {
                if (ForgeEntity.isHostileMob((Entity)living)) {
                    ((HostileMobDying)((Object)((Object)sources.hostileMobDying.get()))).emitFrom(living, 1.0f);
                } else {
                    ((AnimalDying)((Object)((Object)sources.animalDying.get()))).emitFrom(living, 1.0f);
                }
            });
        }
    }
}

