/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.EmittersInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.compat.AdAstra;
import com.endertech.minecraft.mods.adpother.compat.BetterMinecarts;
import com.endertech.minecraft.mods.adpother.compat.BeyondEarth;
import com.endertech.minecraft.mods.adpother.compat.Burnt;
import com.endertech.minecraft.mods.adpother.compat.Caupona;
import com.endertech.minecraft.mods.adpother.compat.ColdSweat;
import com.endertech.minecraft.mods.adpother.compat.Corpse;
import com.endertech.minecraft.mods.adpother.compat.Create;
import com.endertech.minecraft.mods.adpother.compat.CreateTFMG;
import com.endertech.minecraft.mods.adpother.compat.Electrodynamics;
import com.endertech.minecraft.mods.adpother.compat.Extractinator;
import com.endertech.minecraft.mods.adpother.compat.GregTechCEu;
import com.endertech.minecraft.mods.adpother.compat.ImmersiveAircraft;
import com.endertech.minecraft.mods.adpother.compat.ImmersiveEngineering;
import com.endertech.minecraft.mods.adpother.compat.ImmersiveWeathering;
import com.endertech.minecraft.mods.adpother.compat.Minecraft;
import com.endertech.minecraft.mods.adpother.compat.Railcraft;
import com.endertech.minecraft.mods.adpother.compat.SmallShips;
import com.endertech.minecraft.mods.adpother.compat.TrajansTanks;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.CharcoalPit;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import com.endertech.minecraft.mods.adpother.sources.StoveWithPot;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraftforge.common.util.Lazy;

public class Emitters
extends EmittersInit<Emitter, BuiltInEmitters> {
    protected final BlockStatesMap<Emitter> randomlyTicking = new BlockStatesMap();

    public Emitters(AbstractForgeMod mod) {
        super(mod, BuiltInEmitters.class);
    }

    protected void clearAttachedStates() {
        this.randomlyTicking.clear();
        super.clearAttachedStates();
    }

    protected void attachToStates() {
        super.attachToStates();
        for (Emitter emitter : this.streamAll().toList()) {
            UnitId id = emitter.getRelatedId();
            switch (emitter.getType()) {
                case FUEL: {
                    if (!AbstractForgeMod.isLoaded((String)id.getModId())) break;
                    BuiltInRegistries.ENTITY_TYPE.getOptional(id.toResLoc()).ifPresent(type -> this.entities.put(type, emitter));
                    break;
                }
                case BLOCK: {
                    this.randomlyTicking.put(id, (Object)emitter);
                }
            }
        }
    }

    public Optional<Emitter> getRandomlyTicking(BlockState state) {
        return Optional.ofNullable((Emitter)((Object)this.randomlyTicking.get((Object)state)));
    }

    public Emitter createCustomUnitFrom(UnitConfig config, String name) {
        UnitId id = UnitId.from((Path)config.getConfigFile().toPath());
        return new Emitter(config, (Emitter.Properties<?>)Emitter.Properties.tile("").id(id));
    }

    public Emitter createDefaultUnitFrom(UnitConfig config, BuiltInEmitters e) {
        return ((Emitter.Properties)((Object)e.props.get())).factory.orElse(Emitter::new).apply(config, (Emitter.Properties)((Object)e.props.get()));
    }

    static enum BuiltInEmitters implements IForgeEnum
    {
        ad_astra$coal_generator(() -> Emitter.Properties.fuel("")),
        ad_astra$tier_1_rover(AdAstra::rover),
        ad_astra$tier_1_rocket(() -> AdAstra.rocket(1)),
        ad_astra$tier_2_rocket(() -> AdAstra.rocket(2)),
        ad_astra$tier_3_rocket(() -> AdAstra.rocket(3)),
        ad_astra$tier_4_rocket(() -> AdAstra.rocket(4)),
        ad_extendra$tier_5_rocket(() -> AdAstra.rocket(5)),
        ad_extendra$tier_6_rocket(() -> AdAstra.rocket(6)),
        ad_extendra$tier_7_rocket(() -> AdAstra.rocket(7)),
        ad_extendra$tier_8_rocket(() -> AdAstra.rocket(8)),
        ad_extendra$tier_9_rocket(() -> AdAstra.rocket(9)),
        ad_extendra$tier_10_rocket(() -> AdAstra.rocket(10)),
        ad_extendra$tier_11_rocket(() -> AdAstra.rocket(11)),
        bakery$brick_stove(() -> Emitter.Properties.fuel("BurnTime")),
        bakery$cobblestone_stove(() -> Emitter.Properties.fuel("BurnTime")),
        bakery$deepslate_stove(() -> Emitter.Properties.fuel("BurnTime")),
        bakery$end_stove(() -> Emitter.Properties.fuel("BurnTime")),
        bakery$granite_stove(() -> Emitter.Properties.fuel("BurnTime")),
        bakery$mud_stove(() -> Emitter.Properties.fuel("BurnTime")),
        bakery$quartz_stove(() -> Emitter.Properties.fuel("BurnTime")),
        bakery$red_nether_bricks_stove(() -> Emitter.Properties.fuel("BurnTime")),
        bakery$sandstone_stove(() -> Emitter.Properties.fuel("BurnTime")),
        bakery$stone_bricks_stove(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$cobblestone_generator(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("CobTime").carbon(1.0f)))).sulfur(1.0f)))),
        betterfurnacesreforged$iron_forge(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$iron_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$copper_forge(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$copper_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$steel_forge(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$steel_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$gold_forge(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$gold_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$amethyst_forge(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$amethyst_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$diamond_forge(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$diamond_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$platinum_forge(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$platinum_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$netherhot_forge(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$netherhot_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$extreme_forge(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$extreme_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$ultimate_forge(() -> Emitter.Properties.fuel("BurnTime")),
        betterfurnacesreforged$ultimate_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        betterminecarts$diesel_locomotive(() -> BetterMinecarts.DieselLocomotive.properties("Power")),
        betterminecarts$steam_locomotive(() -> BetterMinecarts.locomotive("Burn")),
        beyond_earth$coal_generator(() -> Emitter.Properties.fuel("")),
        beyond_earth$rover(BeyondEarth.Rover::properties),
        beyond_earth$tiny_rocket(() -> BeyondEarth.Rocket.properties(1)),
        beyond_earth$rocket_t1(() -> BeyondEarth.Rocket.properties(1)),
        beyond_earth$rocket_t2(() -> BeyondEarth.Rocket.properties(2)),
        beyond_earth$rocket_t3(() -> BeyondEarth.Rocket.properties(3)),
        beyond_earth$rocket_t4(() -> BeyondEarth.Rocket.properties(4)),
        brickfurnace$brick_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        brickfurnace$brick_blast_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        brickfurnace$brick_smoker(() -> Emitter.Properties.fuel("BurnTime")),
        burningfurnace$generator(() -> Emitter.Properties.fuel("CurrentFuel")),
        burnt$burning_bamboo(Burnt::wood),
        burnt$burning_doors(Burnt::doors),
        burnt$burning_fence_gates(Burnt::fences),
        burnt$burning_fences(Burnt::fences),
        burnt$burning_grass(Burnt::grass),
        burnt$burning_leaves(Burnt::leaves),
        burnt$burning_logs(Burnt::wood),
        burnt$burning_planks(Burnt::wood),
        burnt$burning_slabs(Burnt::slabs),
        burnt$burning_stairs(Burnt::stairs),
        burnt$burning_stripped_logs(Burnt::wood),
        burnt$burning_stripped_wood(Burnt::wood),
        burnt$burning_wood(Burnt::wood),
        burnt$smoldering_carpet(Burnt::carpet),
        burnt$smoldering_hay(Burnt::hay),
        burnt$smoldering_wool(Burnt::wool),
        burnt$stairs_fire(Burnt::fire),
        burnt$tall_grass_fire(Burnt::tall_grass_fire),
        burnt$wood_fire(Burnt::fire),
        byg$boric_campfire(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Minecraft.campfire("byg:boric_campfire", false).carbon(0.5f)))).sulfur(0.05f)))),
        byg$boric_campfire_signal(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Minecraft.campfire("byg:boric_campfire", true).carbon(1.0f)))).sulfur(0.1f)))),
        byg$cryptic_campfire(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Minecraft.campfire("byg:cryptic_campfire", false).carbon(0.5f)))).sulfur(0.2f)))),
        byg$cryptic_campfire_signal(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Minecraft.campfire("byg:cryptic_campfire", false).carbon(1.0f)))).sulfur(0.4f)))),
        car$blastfurnace(() -> Emitter.Properties.fuel("")),
        car$car(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.entity("started", WorldEvents.Alignment.BACK).carbon(2.0f)))).sulfur(0.2f)))),
        car$generator(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile(BlockStateProperties.POWERED).carbon(6.0f)))).sulfur(0.6f)))),
        caupona$brick_kitchen_stove(() -> Emitter.Properties.fuel("process").customFactory(Caupona.KitchenStove::new)),
        caupona$mud_kitchen_stove(() -> Emitter.Properties.fuel("process").customFactory(Caupona.KitchenStove::new)),
        caupona$opus_incertum_kitchen_stove(() -> Emitter.Properties.fuel("process").customFactory(Caupona.KitchenStove::new)),
        caupona$opus_latericium_kitchen_stove(() -> Emitter.Properties.fuel("process").customFactory(Caupona.KitchenStove::new)),
        caupona$stone_brick_kitchen_stove(() -> Emitter.Properties.fuel("process").customFactory(Caupona.KitchenStove::new)),
        charcoal_pit$active_pile(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)CharcoalPit.tile("time").carbon(0.1f)))).sulfur(0.01f)))),
        charcoal_pit$pottery_kiln(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)CharcoalPit.tile("time").carbon(0.1f)))).sulfur(0.01f)))),
        charcoal_pit$blast_furnace(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("burnTime").carbon(1.0f)))).sulfur(0.1f)))),
        charcoal_pit$bloomeryy(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("burnTime").carbon(1.0f)))).sulfur(0.1f)))),
        charcoal_pit$distillery(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("burnTime").carbon(1.0f)))).sulfur(0.1f)))),
        charcoal_pit$steam_press(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("burnTime").carbon(1.0f)))).sulfur(0.1f)))),
        clayworks$kiln(() -> Emitter.Properties.fuel("BurnTime")),
        cold_sweat$boiler(ColdSweat::boiler),
        cold_sweat$hearth(ColdSweat::hearth),
        cookingforblockheads$oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$white_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$orange_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$magenta_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$light_blue_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$yellow_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$lime_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$pink_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$gray_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$light_gray_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$cyan_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$purple_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$blue_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$brown_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$green_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$red_oven(() -> Emitter.Properties.fuel("BurnTime")),
        cookingforblockheads$black_oven(() -> Emitter.Properties.fuel("BurnTime")),
        corpse$corpse(Corpse::properties),
        create$boiler(Create::boiler),
        create$millstone(Create::millstone),
        create$blaze_burner(Create::blazeBurner),
        create$crushing_wheel_controller(Create::crushingWheel),
        createaddition$crude_burner(Create::fuelBurner),
        createaddition$furnace_burner(Create::fuelBurner),
        createaddition$liquid_blaze_burner(Create::blazeBurner),
        createdieselgenerators$diesel_engine(() -> Emitter.Properties.fuel("")),
        createdieselgenerators$large_diesel_engine(() -> Emitter.Properties.fuel("")),
        createdieselgenerators$huge_diesel_engine(() -> Emitter.Properties.fuel("")),
        createlowheated$basic_burner(() -> Emitter.Properties.fuel("BurnTimeRemaining")),
        createtfmg$compact_engine(() -> CreateTFMG.Engine.simple("compact")),
        createtfmg$low_grade_fuel_engine(() -> CreateTFMG.Engine.simple("low_grade_fuel")),
        createtfmg$radial_engine(() -> CreateTFMG.Engine.simple("radial")),
        createtfmg$large_radial_engine(() -> CreateTFMG.Engine.simple("large_radial")),
        createtfmg$diesel_engine(() -> CreateTFMG.Engine.expanded("diesel")),
        createtfmg$gasoline_engine(() -> CreateTFMG.Engine.backed("gasoline")),
        createtfmg$lpg_engine(() -> CreateTFMG.Engine.backed("lpg")),
        createtfmg$turbine_engine(() -> CreateTFMG.Engine.backed("turbine")),
        createtfmg$flarestack(CreateTFMG::flarestack),
        createtfmg$blast_furnace(CreateTFMG::blastFurnace),
        createtfmg$coke_oven(CreateTFMG::cokeOven),
        crossroads$firebox(() -> Emitter.Properties.fuel("burn")),
        crossroads$stamp_mill(() -> ((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("prog").dust(1.0f)))).relatedBlocks("crossroads:stamp_mill_top:*")),
        crossroads$millstone(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("prog").dust(1.0f)))),
        divinerpg$coalstone_furnace(() -> Emitter.Properties.fuel("isLit")),
        divinerpg$greenlight_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        divinerpg$oceanfire_furnace(() -> Emitter.Properties.fuel("isLit")),
        divinerpg$molten_furnace(() -> Emitter.Properties.fuel("isLit")),
        divinerpg$whitefire_furnace(() -> Emitter.Properties.fuel("isLit")),
        divinerpg$moonlight_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        divinerpg$demon_furnace(() -> Emitter.Properties.fuel("isLit")),
        draconicevolution$generator(() -> Emitter.Properties.fuel("bc_managed_data/active")),
        electrodynamics$coalgenerator(() -> Emitter.Properties.fuel("burnTime")),
        electrodynamics$combustionchamber(() -> Emitter.Properties.fuel("running", 5.0f)),
        electrodynamics$mineralcrusher(() -> Electrodynamics.dustMachine(1.0f)),
        electrodynamics$mineralcrusherdouble(() -> Electrodynamics.dustMachine(1.0f)),
        electrodynamics$mineralcrushertriple(() -> Electrodynamics.dustMachine(1.0f)),
        electrodynamics$mineralgrinder(() -> Electrodynamics.dustMachine(1.0f)),
        electrodynamics$mineralgrinderdouble(() -> Electrodynamics.dustMachine(1.0f)),
        electrodynamics$mineralgrindertriple(() -> Electrodynamics.dustMachine(1.0f)),
        electrodynamics$wiremill(() -> Electrodynamics.dustMachine(1.0f)),
        electrodynamics$wiremilldouble(() -> Electrodynamics.dustMachine(1.0f)),
        electrodynamics$wiremilltriple(() -> Electrodynamics.dustMachine(1.0f)),
        enderio$primitive_alloy_smelter(() -> Emitter.Properties.fuel("BurnTime")),
        enderio$stirling_generator(() -> Emitter.Properties.fuel("")),
        enderio$sag_mill(() -> (Emitter.Properties)((Object)((Object)((SourceBase.Properties)((Object)((Object)Emitter.Properties.tile("").statePowered()))).dust(1.0f)))),
        extractinator$extractinator(() -> ((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("").dust(5.0f)))).customFactory(Extractinator::new)),
        farmersdelight$stove(StoveWithPot::tile),
        futurepack$industrial_furnace(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((SourceBase.Properties)((Object)((Object)Emitter.Properties.tile("progress").stateLit()))).carbon(1.0f)))).sulfur(0.1f)))),
        futurepack$part_press(() -> Emitter.Properties.fuel("burn")),
        generatorgalore$copper_generator(() -> Emitter.Properties.fuel("litTime")),
        generatorgalore$culinary_generator(() -> Emitter.Properties.fuel("litTime")),
        generatorgalore$diamond_generator(() -> Emitter.Properties.fuel("litTime")),
        generatorgalore$emerald_generator(() -> Emitter.Properties.fuel("litTime")),
        generatorgalore$enchantment_generator(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("litTime").carbon(0.4f)))).sulfur(0.2f)))),
        generatorgalore$ender_generator(() -> Emitter.Properties.fuel("litTime")),
        generatorgalore$gold_generator(() -> Emitter.Properties.fuel("litTime")),
        generatorgalore$halitosis_generator(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("litTime").carbon(0.4f)))).sulfur(0.2f)))),
        generatorgalore$honey_generator(() -> Emitter.Properties.fuel("litTime")),
        generatorgalore$iron_generator(() -> Emitter.Properties.fuel("litTime")),
        generatorgalore$magmatic_generator(() -> Emitter.Properties.fuel("litTime")),
        generatorgalore$netherite_generator(() -> Emitter.Properties.fuel("litTime")),
        generatorgalore$netherstar_generator(() -> Emitter.Properties.fuel("litTime")),
        generatorgalore$obsidian_generator(() -> Emitter.Properties.fuel("litTime")),
        generatorgalore$potion_generator(() -> Emitter.Properties.fuel("litTime")),
        gtceu$primitive_blast_furnace(() -> GregTechCEu.brickOven(3.0f, "firebricks")),
        gtceu$coke_oven(() -> GregTechCEu.cokeOven(3.0f)),
        gtceu$lp_steam_solid_boiler(() -> GregTechCEu.boiler(1.0f)),
        gtceu$hp_steam_solid_boiler(() -> GregTechCEu.boiler(1.0f)),
        gtceu$lp_steam_liquid_boiler(() -> GregTechCEu.boiler(1.0f)),
        gtceu$hp_steam_liquid_boiler(() -> GregTechCEu.boiler(1.0f)),
        gtceu$bronze_large_boiler(() -> GregTechCEu.largeBoiler(3.0f, "steam", "bronze")),
        gtceu$steel_large_boiler(() -> GregTechCEu.largeBoiler(3.0f, "solid", "steel")),
        gtceu$titanium_large_boiler(() -> GregTechCEu.largeBoiler(3.0f, "stable", "titanium")),
        gtceu$tungstensteel_large_boiler(() -> GregTechCEu.largeBoiler(3.0f, "robust", "tungstensteel")),
        gtceu$large_combustion_engine(() -> GregTechCEu.largeEngine(3.0f, "stable")),
        gtceu$extreme_combustion_engine(() -> GregTechCEu.largeEngine(3.0f, "robust")),
        gtceu$lv_gas_turbine(() -> GregTechCEu.gasTurbine(0.6f)),
        gtceu$mv_gas_turbine(() -> GregTechCEu.gasTurbine(0.8f)),
        gtceu$hv_gas_turbine(() -> GregTechCEu.gasTurbine(1.0f)),
        gtceu$gas_large_turbine(() -> GregTechCEu.largeGasTurbine(3.0f, "clean")),
        gtceu$lp_steam_rock_crusher(() -> GregTechCEu.crusher(1.0f)),
        gtceu$hp_steam_rock_crusher(() -> GregTechCEu.crusher(1.0f)),
        gtceu$lp_steam_macerator(() -> GregTechCEu.crusher(1.0f)),
        gtceu$hp_steam_macerator(() -> GregTechCEu.crusher(1.0f)),
        gtceu$lv_macerator(() -> GregTechCEu.crusher(1.0f)),
        gtceu$mv_macerator(() -> GregTechCEu.crusher(1.2f)),
        gtceu$hv_macerator(() -> GregTechCEu.crusher(1.4f)),
        gtceu$ev_macerator(() -> GregTechCEu.crusher(1.6f)),
        gtceu$iv_macerator(() -> GregTechCEu.crusher(1.8f)),
        gtceu$luv_macerator(() -> GregTechCEu.crusher(2.0f)),
        gtceu$zpm_macerator(() -> GregTechCEu.crusher(2.2f)),
        gtceu$uv_macerator(() -> GregTechCEu.crusher(2.4f)),
        gtceu$steam_grinder(() -> GregTechCEu.largeCrusher(3.0f, "steam")),
        gtceu$large_maceration_tower(() -> GregTechCEu.macerationTower(3.0f, "secure")),
        gtceu$steam_miner(() -> GregTechCEu.crusher(0.6f)),
        gtceu$lv_miner(() -> GregTechCEu.crusher(1.0f)),
        gtceu$mv_miner(() -> GregTechCEu.crusher(1.2f)),
        gtceu$hv_miner(() -> GregTechCEu.crusher(1.4f)),
        gtceu$ev_large_miner(() -> GregTechCEu.largeCrusher(3.0f, "solid")),
        gtceu$iv_large_miner(() -> GregTechCEu.largeCrusher(3.4f, "stable")),
        gtceu$luv_large_miner(() -> GregTechCEu.largeCrusher(3.8f, "robust")),
        handcrafted$oven(() -> Emitter.Properties.fuel("BurnTime")),
        hardcore_torches$hardcore_campfire(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile(BlockStateProperties.LIT).carbon(0.125f)))).sulfur(0.0125f)))),
        hardcore_torches$stove(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile(BlockStateProperties.LIT).carbon(0.125f)))).sulfur(0.0125f)))).relatedBlocks(StoveWithPot.COOKING_POTS)),
        hbm$shredder(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("shredder.shred").dust(1.0f)))),
        hbm$burner_press(() -> Emitter.Properties.fuel("burner_press.fuel").relatedBlocks("hbm:burner_press_part:*")),
        ic2$alloy_smelter(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("active").sulfur(0.1f)))),
        ic2$colossal_furnace(() -> ((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("active").sulfur(0.3f)))).relatedBlocks("ic2:colossal_base_block:*")),
        ic2$colossal_macerator(() -> ((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("active").dust(3.0f)))).relatedBlocks("ic2:colossal_base_block:*")),
        ic2$fuel_boiler(() -> ((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("active").carbon(3.0f)))).relatedBlocks("ic2:fuel_boiler_structure:*")),
        ic2$generator(() -> Emitter.Properties.fuel("active")),
        ic2$iron_furnace(() -> Emitter.Properties.fuel("active")),
        ic2$liquid_generator(() -> Emitter.Properties.fuel("active")),
        ic2$macerator(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("active").dust(1.0f)))),
        ic2$rotary_macerator(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("active").dust(1.0f)))),
        ic2$slag_generator(() -> Emitter.Properties.fuel("active")),
        ic2$stone_canner(() -> Emitter.Properties.fuel("active")),
        ic2$stone_macerator(() -> Emitter.Properties.fuel("active")),
        ic2$wood_gassifier(() -> Emitter.Properties.fuel("active")),
        immersive_aircraft$airship(ImmersiveAircraft::vehicle),
        immersive_aircraft$biplane(ImmersiveAircraft::vehicle),
        immersive_aircraft$cargo_airship(ImmersiveAircraft::vehicle),
        immersive_aircraft$gyrodyne(ImmersiveAircraft::vehicle),
        immersive_aircraft$quadrocopter(ImmersiveAircraft::vehicle),
        immersive_aircraft$warship(ImmersiveAircraft::vehicle),
        immersive_weathering$charred_log(ImmersiveWeathering::log),
        immersive_weathering$charred_planks(ImmersiveWeathering::planks),
        immersive_weathering$charred_stairs(ImmersiveWeathering::stairs),
        immersive_weathering$charred_slab(ImmersiveWeathering::slab),
        immersive_weathering$charred_fence(ImmersiveWeathering::fence),
        immersive_weathering$charred_fence_gate(ImmersiveWeathering::fence),
        immersiveengineering$alloy_smelter(() -> Emitter.Properties.fuel("active").relatedBlocks("immersiveengineering:alloy_smelter:*")),
        immersiveengineering$coke_oven(() -> Emitter.Properties.fuel("active").relatedBlocks("immersiveengineering:coke_oven:*")),
        immersiveengineering$blast_furnace(() -> Emitter.Properties.fuel("active").relatedBlocks("immersiveengineering:blast_furnace:*")),
        immersiveengineering$advanced_blast_furnace(() -> Emitter.Properties.fuel("active").relatedBlocks("immersiveengineering:advanced_blast_furnace:*")),
        immersiveengineering$diesel_generator(() -> Emitter.Properties.fuel("active").relatedBlocks("immersiveengineering:diesel_generator:*")),
        immersiveengineering$bucket_wheel(() -> (Emitter.Properties)((Object)((Object)((SourceBase.Properties)((Object)((Object)Emitter.Properties.tile("active").metadata("[multiblockslave=false]").relatedBlocks("immersiveengineering:bucket_wheel:*")))).dust(1.0f)))),
        immersiveengineering$crusher(() -> (Emitter.Properties)((Object)((Object)((SourceBase.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("").metadata("[multiblockslave=false]").customFactory(ImmersiveEngineering.Crusher::new)))).relatedBlocks("immersiveengineering:crusher:*")))).dust(4.0f)))),
        immersivepetroleum$portable_generator(() -> (Emitter.Properties)Emitter.Properties.fuel("isActive").id("immersivepetroleum:gas_generator:*")),
        immersivepetroleum$speedboat(() -> Emitter.Properties.fuel("")),
        immersiverailroading$diesel_locomotive(() -> (Emitter.Properties)Emitter.Properties.fuel("").id("immersiverailroading:locomotivediesel")),
        immersiverailroading$steam_locomotive(() -> (Emitter.Properties)Emitter.Properties.fuel("").id("immersiverailroading:locomotivesteam")),
        industrialforegoing$biofuel_generator(() -> Emitter.Properties.fuel("progressBar/Tick")),
        industrialforegoing$pitiful_generator(() -> Emitter.Properties.fuel("progressBar/Tick")),
        ironfurnaces$iron_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$gold_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$diamond_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$emerald_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$obsidian_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$crystal_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$netherite_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$copper_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$silver_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        ironfurnaces$million_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        jumbofurnace$jumbo_furnace(() -> Emitter.Properties.fuel("burn_time").relatedBlocks("jumbofurnace:jumbo_furnace:*")),
        legendarysurvivaloverhaul$heater(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile(BlockStateProperties.LIT).carbon(3.0f)))).sulfur(0.03f)))).relatedBlocks("legendarysurvivaloverhaul:heater_top:*")),
        littlelogistics$steam_locomotive(() -> Emitter.Properties.fuel("burn")),
        littlelogistics$tug(() -> Emitter.Properties.fuel("burn")),
        meadow$stove_tiles_wood(StoveWithPot::block),
        meadow$cooking_cauldron(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((SourceBase.Properties)((Object)((Object)Emitter.Properties.tile("CookingTime").activeProperty("hanging")))).carbon(0.8f)))).sulfur(0.08f)))),
        meadow$fondue(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("fondue.progress").carbon(0.5f)))).sulfur(0.05f)))),
        meadow$stove_tiles_lid(() -> Emitter.Properties.fuel("BurnTime")),
        mekanism$crusher(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("activeState").dust(1.0f)))),
        mekanism$basic_crushing_factory(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("activeState").dust(2.0f)))),
        mekanism$advanced_crushing_factory(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("activeState").dust(3.0f)))),
        mekanism$elite_crushing_factory(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("activeState").dust(4.0f)))),
        mekanism$ultimate_crushing_factory(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("activeState").dust(5.0f)))),
        mekanism$fuelwood_heater(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("activeState").carbon(1.5f)))).sulfur(0.15f)))),
        mekanismgenerators$gas_burning_generator(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("activeState").carbon(0.5f)))).sulfur(0.05f)))),
        mekanismgenerators$bio_generator(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("activeState").carbon(0.325f)))),
        mekanismgenerators$heat_generator(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("activeState").carbon(100.0f)))).sulfur(10.0f)))),
        minecraft$furnace(Minecraft::furnace),
        minecraft$smoker(Minecraft::furnace),
        minecraft$blast_furnace(Minecraft::furnace),
        minecraft$furnace_minecart(Minecraft::minecart),
        minecraft$fire(Minecraft::fire),
        minecraft$firework_rocket(Minecraft::firework),
        minecraft$lava(Emitter.Properties::block),
        minecraft$campfire(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Minecraft.campfire("campfire", false).carbon(0.5f)))).sulfur(0.05f)))),
        minecraft$campfire_signal(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Minecraft.campfire("campfire", true).carbon(1.0f)))).sulfur(0.1f)))),
        minecraft$soul_campfire(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Minecraft.campfire("soul_campfire", false).carbon(0.5f)))).sulfur(0.2f)))),
        minecraft$soul_campfire_signal(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Minecraft.campfire("soul_campfire", true).carbon(1.0f)))).sulfur(0.4f)))),
        mysticalagriculture$basic_reprocessor(() -> Emitter.Properties.fuel("FuelLeft")),
        mysticalagriculture$inferium_reprocessor(() -> Emitter.Properties.fuel("FuelLeft")),
        mysticalagriculture$inferium_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        mysticalagriculture$prudentium_reprocessor(() -> Emitter.Properties.fuel("FuelLeft")),
        mysticalagriculture$prudentium_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        mysticalagriculture$tertium_reprocessor(() -> Emitter.Properties.fuel("FuelLeft")),
        mysticalagriculture$tertium_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        mysticalagriculture$imperium_reprocessor(() -> Emitter.Properties.fuel("FuelLeft")),
        mysticalagriculture$imperium_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        mysticalagriculture$supremium_reprocessor(() -> Emitter.Properties.fuel("FuelLeft")),
        mysticalagriculture$supremium_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        nethersdelight$blackstone_stove(StoveWithPot::tile),
        nethersdelight$blackstone_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        nethersdelight$blackstone_blast_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        nethersdelight$nether_brick_smoker(() -> Emitter.Properties.fuel("BurnTime")),
        plane$bush_plane(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.entity("Started", WorldEvents.Alignment.BACK).carbon(4.0f)))).sulfur(0.4f)))),
        plane$cargo_plane(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.entity("Started", WorldEvents.Alignment.BACK).carbon(5.0f)))).sulfur(0.5f)))),
        plane$plane(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.entity("Started", WorldEvents.Alignment.BACK).carbon(4.0f)))).sulfur(0.4f)))),
        pneumaticcraft$air_compressor(() -> Emitter.Properties.fuel("burnTime")),
        pneumaticcraft$advanced_air_compressor(() -> Emitter.Properties.fuel("burnTime")),
        pneumaticcraft$liquid_compressor(() -> Emitter.Properties.fuel("internalFuelBuffer")),
        pneumaticcraft$advanced_liquid_compressor(() -> Emitter.Properties.fuel("internalFuelBuffer")),
        projecte$dm_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        projecte$rm_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        quark$blackstone_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        quark$deepslate_furnace(() -> Emitter.Properties.fuel("BurnTime")),
        quarryplus$solid_fuel_quarry(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("fuelCount").carbon(1.0f)))).sulfur(0.1f)))),
        railcraft$blast_furnace(Railcraft::blastFurnace),
        railcraft$coke_oven(Railcraft::cokeOven),
        railcraft$crusher(Railcraft::crusher),
        railcraft$fluid_fueled_firebox(Railcraft::fueledFirebox),
        railcraft$solid_fueled_firebox(Railcraft::fueledFirebox),
        railcraft$steam_locomotive(Railcraft::steamLocomotive),
        railcraft$tunnel_bore(Railcraft::tunnelBore),
        rftoolspower$blazing_generator(() -> Emitter.Properties.fuel("")),
        rftoolspower$coal_generator(() -> (Emitter.Properties)Emitter.Properties.fuel("").id("rftoolspower:coalgenerator:*")),
        securitycraft$keypad_furnace(Minecraft::furnace),
        securitycraft$keypad_blast_furnace(Minecraft::furnace),
        securitycraft$keypad_smoker(Minecraft::furnace),
        silents_mechanisms$basic_crusher(() -> (Emitter.Properties)((Object)((Object)((SourceBase.Properties)((Object)((Object)Emitter.Properties.tile("Progress").stateLit()))).dust(1.0f)))),
        silents_mechanisms$crusher(() -> (Emitter.Properties)((Object)((Object)((SourceBase.Properties)((Object)((Object)Emitter.Properties.tile("Progress").stateLit()))).dust(1.0f)))),
        silents_mechanisms$coal_generator(() -> Emitter.Properties.fuel("BurnTime")),
        silents_mechanisms$diesel_generator(() -> Emitter.Properties.fuel("BurnTime")),
        silents_mechanisms$lava_generator(() -> Emitter.Properties.fuel("BurnTime")),
        simpleplanes$plane(() -> Emitter.Properties.fuel("")),
        simpleplanes$large_plane(() -> Emitter.Properties.fuel("")),
        simpleplanes$helicopter(() -> Emitter.Properties.fuel("")),
        smallships$cannon_ball(() -> SmallShips.CannonBall.properties(1.0f)),
        steampowered$cast_iron_burner(() -> Emitter.Properties.fuel("hu")),
        steampowered$bronze_burner(() -> Emitter.Properties.fuel("hu")),
        steampowered$steel_burner(() -> Emitter.Properties.fuel("hu")),
        tconstruct$seared_melter(() -> Emitter.Properties.fuel("fuel").relatedBlocks("#tconstruct:fuel_tanks")),
        tconstruct$foundry_controller(() -> Emitter.Properties.fuel("fuel").relatedBlocks("#tconstruct:foundry/wall", "#tconstruct:foundry/floor")),
        tconstruct$smeltery_controller(() -> Emitter.Properties.fuel("fuel").relatedBlocks("#tconstruct:smeltery/wall", "#tconstruct:smeltery/floor")),
        tfc$blast_furnace(() -> Emitter.Properties.fuel("burnTicks").relatedBlocks("tfc:molten:*")),
        tfc$charcoal_forge(() -> Emitter.Properties.fuel("burnTicks").relatedBlocks("tfc:bellows:*", "tfc:crucible:*")),
        tfc$firepit(() -> Emitter.Properties.fuel("burnTicks")),
        tfc$pot(() -> Emitter.Properties.fuel("burnTicks")),
        tfc$grill(() -> Emitter.Properties.fuel("burnTicks")),
        tfc$bloomery(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((SourceBase.Properties)((Object)((Object)Emitter.Properties.tile(BlockStateProperties.LIT).relatedBlocks("tfc:molten:*")))).carbon(1.0f)))).sulfur(0.1f)))),
        tfc$burning_log_pile(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((SourceBase.Properties)((Object)((Object)Emitter.Properties.tile("tick").customFactory(CharcoalPit::new)))).carbon(0.1f)))).sulfur(0.01f)))),
        tfc$pit_kiln(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("isLit").carbon(1.0f)))).sulfur(0.1f)))),
        thermal$dynamo_stirling(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("Active").carbon(1.0f)))).sulfur(0.1f)))),
        thermal$dynamo_compression(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("Active").carbon(1.0f)))).sulfur(0.1f)))),
        thermal$dynamo_magmatic(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("Active").carbon(1.0f)))).sulfur(0.4f)))),
        thermal$machine_furnace(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("Active").carbon(0.2f)))).sulfur(0.02f)))),
        thermal$machine_smelter(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.tile("Active").carbon(0.2f)))).sulfur(0.02f)))),
        thermal$machine_pulverizer(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("Active").dust(1.0f)))),
        thermal$machine_sawmill(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("Active").dust(1.0f)))),
        trajanstanks$panzer_two(() -> TrajansTanks.Tank.properties("panzer_two")),
        trajanstanks$tiger_tank(() -> TrajansTanks.Tank.properties("tiger_tank")),
        trajanstanks$m4sherman(() -> TrajansTanks.Tank.properties("m4sherman")),
        trajanstanks$t34(() -> TrajansTanks.Tank.properties("t34")),
        trajanstanks$cruisermk1(() -> TrajansTanks.Tank.properties("cruisermk1")),
        twilightdelight$maze_stove(StoveWithPot::tile),
        ytech$primitive_alloy_smelter(() -> Emitter.Properties.fuel("burningLeft")),
        ytech$primitive_smelter(() -> Emitter.Properties.fuel("burningLeft")),
        ytech$fire_pit(() -> (Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((SourceBase.Properties)((Object)((Object)Emitter.Properties.block().stateLit()))).carbon(0.5f)))).sulfur(0.05f)))),
        ytech$millstone(() -> (Emitter.Properties)((Object)((Object)Emitter.Properties.tile("isMilling").dust(1.0f)))),
        vehicle$atv(() -> Emitter.Properties.fuel("")),
        vehicle$dune_buggy(() -> Emitter.Properties.fuel("")),
        vehicle$go_kart(() -> Emitter.Properties.fuel("")),
        vehicle$shopping_cart(() -> Emitter.Properties.fuel("")),
        vehicle$mini_bike(() -> Emitter.Properties.fuel("")),
        vehicle$bumper_car(() -> Emitter.Properties.fuel("")),
        vehicle$jet_ski(() -> Emitter.Properties.fuel("")),
        vehicle$speed_boat(() -> Emitter.Properties.fuel("")),
        vehicle$aluminum_boat(() -> Emitter.Properties.fuel("")),
        vehicle$smart_car(() -> Emitter.Properties.fuel("")),
        vehicle$lawn_mower(() -> Emitter.Properties.fuel("")),
        vehicle$moped(() -> Emitter.Properties.fuel("")),
        vehicle$sports_plane(() -> Emitter.Properties.fuel("")),
        vehicle$golf_cart(() -> Emitter.Properties.fuel("")),
        vehicle$off_roader(() -> Emitter.Properties.fuel("")),
        vehicle$tractor(() -> Emitter.Properties.fuel("")),
        vehicle$mini_bus(() -> Emitter.Properties.fuel("")),
        vehicle$dirt_bike(() -> Emitter.Properties.fuel("")),
        cfm$couch(() -> Emitter.Properties.fuel("")),
        cfm$bath(() -> Emitter.Properties.fuel("")),
        cfm$sofacopter(() -> Emitter.Properties.fuel(""));

        final Lazy<Emitter.Properties<?>> props = Lazy.of(() -> ((Emitter.Properties)((Object)((Object)props.get()))).emptyToEnumId((Enum)this, true));

        private BuiltInEmitters(Supplier<Emitter.Properties<?>> props) {
        }
    }
}

