/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public abstract class AbstractPollution {
    protected Map<Pollutant<?>, PollutionInfo> infoForPollutant = new ConcurrentHashMap();

    public Stream<PollutionInfo> getInfos() {
        return this.infoForPollutant.values().stream();
    }

    public boolean isEmpty() {
        return this.getInfos().allMatch(PollutionInfo::isEmpty);
    }

    @Nonnull
    public PollutionInfo getOrCreateInfoFor(Pollutant<?> pollutant) {
        PollutionInfo info = this.infoForPollutant.get(pollutant);
        if (info == null) {
            info = new PollutionInfo(pollutant);
            this.infoForPollutant.put(pollutant, info);
        }
        return info;
    }

    public Optional<PollutionInfo> getInfoFor(Pollutant<?> pollutant) {
        return Optional.ofNullable(this.infoForPollutant.get(pollutant));
    }

    public void readFrom(CompoundTag compound) {
        ListTag list = compound.getList("pollutants").orElse(null);
        if (list != null) {
            this.infoForPollutant.clear();
            for (int i = 0; i < list.size(); ++i) {
                list.getCompound(i).map(tag -> new PollutionInfo(null).readFrom((CompoundTag)tag)).filter(info -> !info.isEmpty()).ifPresent(info -> this.infoForPollutant.put(info.getPollutant(), (PollutionInfo)info));
            }
        }
    }

    public void writeTo(CompoundTag compound) {
        ListTag list = new ListTag();
        this.getInfos().filter(info -> !info.isEmpty()).forEach(info -> {
            CompoundTag tag = info.writeTo(new CompoundTag());
            list.add((Object)tag);
        });
        compound.put("pollutants", (Tag)list);
    }
}

