/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PollutionParticle {
    public static <T extends Options> ParticleType<T> simpleParticleType(T options) {
        final MapCodec codec = MapCodec.unit(options);
        final StreamCodec streamCodec = StreamCodec.unit(options);
        return new ParticleType<T>(false){

            public MapCodec<T> codec() {
                return codec;
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                return streamCodec;
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Instance
    extends SingleQuadParticle {
        public Instance(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites, Percentage influence, Pollutant<?> pollutant, RandomSource random) {
            super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprites.first());
            this.setSize(0.02f, 0.02f);
            this.hasPhysics = false;
            this.xd = xSpeed;
            this.yd *= (double)0.1f;
            this.zd = zSpeed;
            float factor = influence.toFraction();
            this.quadSize *= random.nextFloat() * 0.6f + 0.5f;
            this.lifetime = (int)(20.0 / ((double)random.nextFloat() * 0.8 + 0.2));
            this.alpha = GameBounds.FACTOR.getFloatBounds().interpolateUp(factor).floatValue();
            this.sprite = sprites.get(random);
            ColorARGB color = pollutant.getColor();
            this.setColor(color.getRed().toFloat(), color.getGreen().toFloat(), color.getBlue().toFloat());
        }

        protected SingleQuadParticle.Layer getLayer() {
            return SingleQuadParticle.Layer.TRANSLUCENT;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<Options> {
        protected final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(Options options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new Instance(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites, options.influence, options.pollutant, random);
        }
    }

    public static class Options
    implements ParticleOptions {
        public final Percentage influence;
        public final Pollutant<?> pollutant;

        public Options(Percentage influence, Pollutant<?> pollutant) {
            this.influence = influence;
            this.pollutant = pollutant;
        }

        public ParticleType<?> getType() {
            return (ParticleType)AdPother.getInstance().particles.pollution.get();
        }
    }
}

