function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/world/entity/animal/horse/AbstractHorse',
		'methodName' : 'fedFood',
		'methodDesc' : '(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/InteractionResult;'
	}

    var node = {
    	'class' : 'net/minecraft/world/item/ItemStack',
    	'methodName' : 'consume',
    	'methodDesc' : '(ILnet/minecraft/world/entity/LivingEntity;)V'
    }

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFoodConsumed',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/entity/Entity;)V'
	}

	var instructions = [
	    insnPushValue(1, "food amount"),
		insnLoadThis("horse"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, [].concat(instructionsDupValue3("food stack"), instructions));
				return method;
			}
		}
	}
}