function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/mactso/regrowth/events/MoveEntityEvent',
		'methodName' : 'mobEatGrassOrFlower',
		'methodDesc' : '(Lnet/minecraft/world/entity/Entity;Ljava/lang/String;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/level/block/Block;)Z'
	}

    var node = {
		'class' : 'net/minecraft/world/level/Level',
		'methodName' : resolveName('m_46961_'), // destroyBlock
		'methodDesc' : '(Lnet/minecraft/core/BlockPos;Z)Z'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFoodConsumed',
		'methodDesc' : '(Lnet/minecraft/world/level/ItemLike;ILnet/minecraft/world/entity/Entity;)V'
	}

	var instructions = [
	    insnLoadObj(3, "eaten block"),
	    insnPushValue(1, "amount"),
	    insnLoadObj(1, "entity"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}