/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.AbstractEntity;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;

public class Railcraft {
    public static final String MOD_ID = "railcraft";

    public static Emitter.Properties<?> cokeOven() {
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)Railcraft.furnace("coke_oven_bricks").carbon(3.0f))).sulfur(0.3f));
    }

    public static Emitter.Properties<?> blastFurnace() {
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)Railcraft.furnace("blast_furnace_bricks").carbon(4.0f))).sulfur(0.4f));
    }

    public static Emitter.Properties<?> crusher() {
        return (Emitter.Properties)((Object)((SourceBase.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.tile("modules/crusher/processing").identityTag(new KeyValuePair("master", "1b")))).enumIdAsRelatedBlocks())).dust(2.0f));
    }

    public static Emitter.Properties<?> fueledFirebox() {
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)((SourceBase.Properties)((Object)Railcraft.litMasterblock().relatedBlocks(Railcraft.steamBoilerTankBlocks("low_pressure"), Railcraft.steamBoilerTankBlocks("high_pressure")))).carbon(0.5f))).sulfur(0.05f));
    }

    public static Emitter.Properties<?> furnace(String material) {
        UnitId id = UnitId.from((String)MOD_ID, (String)material).withMetaAll();
        return Railcraft.litMasterblock().id(id).relatedBlocks(id.withMetaData("[lit=true]").toString());
    }

    public static Emitter.Properties<?> litMasterblock() {
        return Emitter.Properties.tile(BlockStateProperties.LIT).identityTag(new KeyValuePair("master", "1b"));
    }

    static String steamBoilerTankBlocks(String type) {
        return UnitId.from((String)MOD_ID, (String)(type + "_steam_boiler_tank")).withMetaAll().toString();
    }

    public static Emitter.Properties<?> steamLocomotive() {
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.entity("boiler/burnTime", WorldEvents.Alignment.TOP).customFactory(SteamLocomotive::new))).carbon(1.0f))).sulfur(0.1f));
    }

    public static Emitter.Properties<?> tunnelBore() {
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.entity("fuel", WorldEvents.Alignment.CENTER).customFactory(TunnelBore::new))).carbon(1.0f))).sulfur(0.1f));
    }

    public static class TunnelBore
    extends AbstractLocomotive {
        public TunnelBore(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        @Override
        protected float getFuelUsage(INBTSource<?> nbtSource) {
            return nbtSource.serialize().getBooleanOr("active", false) ? 9.0f : 1.0f;
        }

        @Override
        public WorldEvents.Alignment getEmissionsAlignment() {
            return WorldEvents.Alignment.CENTER;
        }
    }

    public static class SteamLocomotive
    extends AbstractLocomotive {
        public SteamLocomotive(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        @Override
        public WorldEvents.Alignment getEmissionsAlignment() {
            return WorldEvents.Alignment.TOP;
        }

        @Override
        protected float getFuelUsage(INBTSource<?> nbtSource) {
            CompoundTag compound = nbtSource.serialize();
            String mode = compound.getStringOr("mode", "");
            if (mode.equalsIgnoreCase("running")) {
                String speed;
                return switch (speed = compound.getStringOr("speed", "").toLowerCase(Locale.ROOT)) {
                    case "slowest" -> 2.0f;
                    case "slower" -> 4.0f;
                    case "normal" -> 6.0f;
                    case "max" -> 8.0f;
                    default -> 1.0f;
                };
            }
            return 1.0f;
        }
    }

    public static abstract class AbstractLocomotive
    extends AbstractEntity {
        protected float fuelUsage = 0.0f;

        public AbstractLocomotive(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        protected abstract float getFuelUsage(INBTSource<?> var1);

        public boolean isActive(INBTSource<?> nbtSource) {
            if (super.isActive(nbtSource)) {
                this.fuelUsage = this.getFuelUsage(nbtSource);
                return true;
            }
            return false;
        }

        @Override
        public void emitAt(Level level, BlockPos pos, float factor) {
            super.emitAt(level, pos, factor * this.fuelUsage);
        }
    }
}

