/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.emissions;

import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.emissions.AbstractEntityEmission;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.common.ModConfigSpec;

public class PeriodicEntityEmission
extends AbstractEntityEmission<Entity, Emitter> {
    public static ModConfigSpec.ConfigValue<Double> rate;

    protected PeriodicEntityEmission(Entity entity, Emitter emitter, GameTime updateInterval) {
        super(entity, emitter, updateInterval);
    }

    public static PeriodicEntityEmission of(Entity entity, Emitter emitter) {
        return new PeriodicEntityEmission(entity, emitter, GameTime.second());
    }

    public boolean isEntityDeadOrRemoved() {
        Entity entity = (Entity)this.getEntity();
        if (!entity.isAlive()) {
            return true;
        }
        return !entity.isAddedToLevel();
    }

    @Override
    public BlockPos getEntityBlockPos() {
        return ((Entity)this.getEntity()).blockPosition();
    }

    public void onUpdate() {
        if (this.isEntityDeadOrRemoved()) {
            this.kill();
            return;
        }
        if (this.isInEntityTickingChunk()) {
            Level level = this.getWorldLevel();
            Emitter emitter = (Emitter)((Object)this.getEmitter());
            if (emitter.isActive(INBTSource.of((Entity)((Entity)this.getEntity())))) {
                float factor = 1.0f;
                if (!emitter.hasSeparateRateControl()) {
                    factor *= ((Double)rate.get()).floatValue();
                }
                BlockPos pos = emitter.getExhaustPosition((LevelAccessor)level, INBTSource.of((Entity)((Entity)this.getEntity())), this.getEntityBlockPos());
                emitter.emitAt(level, pos, factor);
            }
        }
    }

    @Nullable
    public Level getWorldLevel() {
        return ((Entity)this.getEntity()).level();
    }
}

