/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.tiles.ForgeTile;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.impacts.FluidImpacts;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.AnimalFeeding;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.LavaTouchingWater;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.fluids.FluidStack;

@EventBusSubscriber(modid="adpother")
public class WorldEvents {
    public static boolean loggingFuelConsumption = false;
    public static boolean loggingFoodConsumption = false;
    public static ModConfigSpec.ConfigValue<Boolean> furnaceEmissions;
    public static ModConfigSpec.ConfigValue<Boolean> burntBlockEmissions;
    public static ModConfigSpec.ConfigValue<Double> burntItemEmissionRate;

    @SubscribeEvent
    public static void onLevelLoaded(LevelEvent.Load event) {
        if (!event.getLevel().isClientSide()) {
            WorldData.initBiomeConfigs();
        }
    }

    @SubscribeEvent
    public static void onLevelUnloaded(LevelEvent.Unload event) {
        WorldData.removeDataFor(event.getLevel());
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WorldData data = WorldData.getData((Level)level2);
            data.tick();
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Entity entity = event.getEntity();
            WorldData data = WorldData.getData((Level)level2);
            data.addIfDroppedTorch(level2, entity);
            data.addIfEmitter(level2, entity);
        }
    }

    @SubscribeEvent
    public static void onEntityLeave(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        Level level = event.getLevel();
        WorldData data = WorldData.getData(level);
        data.removePollutionInfoFor(entity);
        if (GameWorld.isServerSide((LevelReader)level)) {
            data.removePeriodicEmissionFor(entity);
            data.removeIfDroppedTorch(entity);
        }
    }

    @SubscribeEvent
    public static void onBlockChange(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockPos pos = event.getPos();
            BlockEntity tile = level.getBlockEntity(pos);
            BlockState state = event.getState();
            if (tile != null) {
                WorldData.getData((Level)level).addIfEmitter(level, pos, state, tile);
            }
        }
    }

    public static void onBlockStateChange(ServerLevel level, BlockPos pos, BlockState oldState, BlockState newState) {
        WorldData.tryChangePollutionLevelBy(level, pos, oldState, -1);
        WorldData.tryChangePollutionLevelBy(level, pos, newState, 1);
    }

    public static float getRandomTickFactor(ServerLevel level) {
        int baseSpeed = 3;
        int tickSpeed = level.getServer().getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
        return tickSpeed > 0 ? (float)baseSpeed / (float)tickSpeed : 0.0f;
    }

    public static void onBlockRandomTick(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        AdPother mod = AdPother.getInstance();
        if ((Double)Torch.rate.get() > 0.0) {
            mod.torches.get(state).filter(emitter -> emitter.isActive((LevelReader)level, pos)).ifPresent(torch -> torch.emitAt((Level)level, pos, WorldEvents.getRandomTickFactor(level)));
        }
        mod.emitters.getRandomlyTicking(state).filter(emitter -> emitter.isActive((LevelReader)level, pos)).ifPresent(emitter -> emitter.emitAt((Level)level, pos, WorldEvents.getRandomTickFactor(level)));
    }

    public static void onFluidRandomTick(ServerLevel level, BlockPos pos, FluidState fluid, RandomSource random) {
        ((FluidImpacts)AdPother.getInstance().impacts.fluidImpacts.get()).doImpacts(fluid, level, pos);
    }

    public static final void onBlockBroken(Level world, BlockPos pos, BlockState state) {
        AdPother.getInstance().breakables.get(state).ifPresent(breakable -> breakable.emitAt(world, pos));
    }

    public static final void onFoodConsumed(ItemLike food, int amount, Entity entity) {
        WorldEvents.onFoodConsumed(new ItemStack(food, 1), amount, entity);
    }

    public static final void onFoodConsumed(ItemStack food, int amount, Entity entity) {
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            if (!entity.level().isClientSide()) {
                WorldEvents.logConsumedFood(ForgeItem.getRegistryName((Item)food.getItem()).toString(), amount, ForgeEntity.getRegistryName((Entity)entity).toString());
                ((AnimalFeeding)((Object)AdPother.getInstance().sources.animalFeeding.get())).emitFrom(animal, food, amount);
            }
        }
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, BlockEntity tile) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack, stack.getAmount(), tile);
        }
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, int amount, BlockEntity tile) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack.getFluid(), amount, tile);
        }
    }

    public static final void onFuelBurned(@Nullable Fluid fluid, int amount, BlockEntity tile) {
        if (fluid != null) {
            Optional<Fuel> fuel = WorldEvents.asFuel(fluid);
            WorldEvents.logConsumedFuel(ForgeBlock.getRegistryName((Fluid)fluid), fuel, amount, tile);
            if (fuel.isPresent()) {
                WorldEvents.onFuelBurned(fuel.get(), amount, tile);
            }
        }
    }

    private static Optional<Fuel> asFuel(@Nullable Fluid fluid) {
        return fluid != null ? AdPother.getInstance().fuels.get(fluid) : Optional.empty();
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, Entity entity, Alignment alignment) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack, stack.getAmount(), entity, alignment);
        }
    }

    public static final void onFuelBurned(@Nullable FluidStack stack, int amount, Entity entity, Alignment alignment) {
        if (stack != null) {
            WorldEvents.onFuelBurned(stack.getFluid(), amount, entity, alignment);
        }
    }

    public static final void onFuelBurned(@Nullable Fluid fluid, int amount, Entity entity, Alignment alignment) {
        if (fluid != null) {
            Optional<Fuel> fuel = WorldEvents.asFuel(fluid);
            WorldEvents.logConsumedFuel(ForgeBlock.getRegistryName((Fluid)fluid), fuel, amount, ForgeEntity.getRegistryName((Entity)entity));
            if (fuel.isPresent()) {
                WorldEvents.onFuelBurned(fuel.get(), amount, entity, alignment);
            }
        }
    }

    private static Optional<Fuel> asFuel(ItemStack stack) {
        return AdPother.getInstance().fuels.get(stack);
    }

    public static final void onFuelBurned(ItemStack stack, int amount, BlockEntity tile) {
        Optional<Fuel> fuel = WorldEvents.asFuel(stack);
        WorldEvents.logConsumedFuel(ForgeItem.getRegistryName((Item)stack.getItem()), fuel, amount, tile);
        if (fuel.isPresent()) {
            WorldEvents.onFuelBurned(fuel.get(), amount, tile);
        }
    }

    private static void logConsumedFuel(ResourceLocation consumable, Optional<Fuel> fuel, int amount, BlockEntity tile) {
        WorldEvents.logConsumedFuel(consumable, fuel, amount, ForgeTile.getRegistryName((BlockEntity)tile).orElse(ResourceLocation.withDefaultNamespace((String)"unregistered_shit")));
    }

    private static void logConsumedFuel(ResourceLocation consumable, Optional<Fuel> fuel, int amount, ResourceLocation consumer) {
        if (loggingFuelConsumption) {
            AdPother.getInstance().getLogger().info(String.valueOf(consumer) + " consumed " + amount + "x " + String.valueOf(consumable) + " (" + fuel.map(f -> f.getRelatedId().toString()).orElse("no fuel") + ")");
        }
    }

    private static void logConsumedFood(String consumable, int amount, String consumer) {
        if (loggingFoodConsumption) {
            AdPother.getInstance().getLogger().info(consumer + " consumed " + amount + "x " + consumable);
        }
    }

    private static void logNoEmitter(String consumer) {
        if (loggingFuelConsumption) {
            AdPother.getInstance().getLogger().info("Emitter not found for " + consumer + " (no config or incorrect ID)");
        }
    }

    public static final void onFuelBurned(ItemStack stack, int amount, Entity entity, Alignment alignment) {
        Optional<Fuel> fuel = WorldEvents.asFuel(stack);
        WorldEvents.logConsumedFuel(ForgeItem.getRegistryName((Item)stack.getItem()), fuel, amount, ForgeEntity.getRegistryName((Entity)entity));
        if (fuel.isPresent()) {
            WorldEvents.onFuelBurned(fuel.get(), amount, entity, alignment);
        }
    }

    public static final void onFuelBurned(Fuel fuel, int amount, BlockEntity tile) {
        Level level = tile.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockPos tilePos = tile.getBlockPos();
            Emitter emitter = AdPother.getInstance().emitters.get((LevelReader)level2, tilePos).orElse(null);
            if (emitter != null) {
                ChunkPollution pollution = WorldData.getChunkPollution((Level)level2, tilePos);
                BlockPos exhaustPos = emitter.getExhaustPosition((LevelAccessor)level2, INBTSource.of((BlockEntity)tile), tilePos);
                pollution.increaseBy(emitter, IEmitter.Type.TILE, level2, exhaustPos, fuel, amount);
            } else {
                WorldEvents.logNoEmitter(ForgeTile.getRegistryName((BlockEntity)tile).map(ResourceLocation::toString).orElse("null"));
            }
        }
    }

    public static final void onFuelBurned(Fuel fuel, int amount, Entity entity, Alignment alignment) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Emitter emitter = AdPother.getInstance().emitters.get(entity).orElse(null);
            if (emitter != null) {
                BlockPos pos = emitter.getExhaustPosition((LevelAccessor)level2, INBTSource.of((Entity)entity), BlockPos.containing((Position)alignment.getPositionVec(entity)));
                ChunkPollution pollution = WorldData.getChunkPollution((Level)level2, pos);
                pollution.increaseBy(emitter, IEmitter.Type.ENTITY, level2, pos, fuel, amount);
            } else {
                WorldEvents.logNoEmitter(ForgeEntity.getRegistryName((Entity)entity).toString());
            }
        }
    }

    @SubscribeEvent
    public static void onFluidPlacedBlock(BlockEvent.FluidPlaceBlockEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            FluidState fluid;
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockPos pos = event.getPos();
            if (pos.equals((Object)event.getLiquidPos()) && ((fluid = level.getFluidState(pos)).is(FluidTags.LAVA) || fluid.is(FluidTags.WATER))) {
                ((LavaTouchingWater)((Object)AdPother.getInstance().sources.lavaTouchingWater.get())).emitAt((Level)level, pos);
            }
        }
    }

    public static final void onBlockExploded(Level level, BlockPos pos, BlockState state, Explosion explosion) {
        if (!GameWorld.isServerSide((LevelReader)level)) {
            return;
        }
        ((com.endertech.minecraft.mods.adpother.sources.Explosion)((Object)AdPother.getInstance().sources.explosion.get())).emitAt(level, pos);
        WorldEvents.onBlockBroken(level, pos, state);
        if (state.isFlammable((BlockGetter)level, pos, Direction.UP)) {
            WorldEvents.onBlockBurned(state, level, pos);
        }
    }

    public static final void onFurnaceFuelBurned(ItemStack stack, int amount, BlockEntity tile) {
        if (!((Boolean)furnaceEmissions.get()).booleanValue()) {
            return;
        }
        Item item = stack.getItem();
        if (item instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            WorldEvents.onFuelBurned(bucket.content, 1000 * amount, tile);
        } else {
            WorldEvents.onFuelBurned(stack, amount, tile);
        }
    }

    public static final void onBlockBurned(BlockState state, Level world, BlockPos pos) {
        if (((Boolean)burntBlockEmissions.get()).booleanValue() && GameWorld.isServerSide((LevelReader)world)) {
            AdPother.getInstance().fuels.get(state).ifPresent(fuel -> fuel.emitAt(world, pos));
        }
    }

    public static final void onItemBurned(ItemStack stack, Level world, BlockPos pos) {
        Optional<Fuel> fuel;
        if ((Double)burntItemEmissionRate.get() > 0.0 && GameWorld.isServerSide((LevelReader)world) && (fuel = WorldEvents.asFuel(stack)).isPresent()) {
            fuel.get().emitAt(world, pos, (float)stack.getCount() * ((Double)burntItemEmissionRate.get()).floatValue());
        }
    }

    public static final void onLavaFuelBurned(BlockEntity tile, int amount) {
        WorldEvents.onFuelBurned(new FluidStack((Fluid)Fluids.LAVA, amount), tile);
    }

    public static enum Alignment {
        TOP{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.getBoundingBox().getCenter().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
            }
        }
        ,
        CENTER{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.getBoundingBox().getCenter();
            }
        }
        ,
        BOTTOM{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.getBoundingBox().getCenter().subtract(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
            }
        }
        ,
        FRONT{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.getBoundingBox().getCenter().add(entity.getLookAngle().scale((double)(entity.getBbWidth() / 2.0f)));
            }
        }
        ,
        BACK{

            @Override
            public Vec3 getPositionVec(Entity entity) {
                return entity.getBoundingBox().getCenter().subtract(entity.getLookAngle().scale((double)(entity.getBbWidth() / 2.0f)));
            }
        };


        public abstract Vec3 getPositionVec(Entity var1);
    }
}

