/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.mixin.minecraft;

import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.extensions.IBlockStateExtension;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IBlockStateExtension.class})
public interface IBlockStateExtensionMixin {
    @Shadow
    public BlockState self();

    @Inject(method={"onCaughtFire"}, at={@At(value="HEAD")})
    private void onCaughtFire(Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter, CallbackInfoReturnable<Boolean> callback) {
        WorldEvents.onBlockBurned(this.self(), level, pos);
    }

    @Inject(method={"onBlockExploded"}, at={@At(value="HEAD")})
    private void onBlockExploded(ServerLevel level, BlockPos pos, Explosion explosion, CallbackInfo callback) {
        WorldEvents.onBlockExploded((Level)level, pos, this.self(), explosion);
    }
}

