/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonTime;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.init.Sounds;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class GasDetection {
    public static final IntBounds GAS_BLOCKS_THRESHOLD = IntBounds.between((Integer)1, (Integer)8);
    public static final Result EMPTY_RESULT = new Result(false, 0);
    protected final Entity entity;
    protected final int radius;
    protected CompletableFuture<Result> computedResult = CompletableFuture.completedFuture(EMPTY_RESULT);
    protected Result lastComputedResult = EMPTY_RESULT;
    protected CommonTime.Stamp lastBeep = CommonTime.Stamp.now();
    protected AlarmLevel lastBeepedAlarmLevel = AlarmLevel.NONE;

    public GasDetection(Entity entity, int radius) {
        this.entity = entity;
        this.radius = radius;
    }

    public Level getLevel() {
        return this.entity.level();
    }

    public BlockPos getStartPos() {
        return this.entity.blockPosition();
    }

    public WorldBounds getSearchBounds() {
        return WorldBounds.from((BlockPos)this.getStartPos().offset(-this.radius, -this.radius, -this.radius), (BlockPos)this.getStartPos().offset(this.radius, this.radius, this.radius));
    }

    public void update() {
        if (this.entity.isAlive() && ((Aerometer)((Object)AdPother.getInstance().items.aerometer.get())).isClientSideCarrier(this.entity)) {
            if (this.computedResult.isDone()) {
                this.computedResult = CompletableFuture.supplyAsync(() -> new Searcher((LevelAccessor)this.getLevel(), this.getStartPos(), this.getSearchBounds()).buildWithResult());
            }
            this.beepIfGasDetected();
        } else {
            this.lastComputedResult = EMPTY_RESULT;
        }
    }

    public Result getResult() {
        this.lastComputedResult = this.computedResult.getNow(this.lastComputedResult);
        return this.lastComputedResult;
    }

    public AlarmLevel getAlarmLevel() {
        Result result = this.getResult();
        if (result.explosionRisk()) {
            return AlarmLevel.HIGH;
        }
        if (result.gasBlocksAround() >= GAS_BLOCKS_THRESHOLD.getMax()) {
            return AlarmLevel.MEDIUM;
        }
        if (result.gasBlocksAround() > 0) {
            return AlarmLevel.LOW;
        }
        return AlarmLevel.NONE;
    }

    protected void beepIfGasDetected() {
        if (this.getLevel().isClientSide()) {
            AlarmLevel alarmLevel;
            int threshold;
            int beepInterval = (Integer)Aerometer.beepInterval.get();
            Entity entity = this.entity;
            if (entity instanceof ItemFrame) {
                ItemFrame frame = (ItemFrame)entity;
                v0 = frame.getRotation() + 1;
            } else {
                v0 = threshold = GAS_BLOCKS_THRESHOLD.getMin().intValue();
            }
            if (beepInterval > 0 && this.getResult().gasBlocksAround() >= threshold && ((alarmLevel = this.getAlarmLevel()).ordinal() > this.lastBeepedAlarmLevel.ordinal() || CommonTime.Interval.passedFrom((CommonTime.Stamp)this.lastBeep).moreThan(CommonTime.Interval.seconds((double)beepInterval)))) {
                float volume = ((Double)Aerometer.beepVolume.get()).floatValue();
                float pitch = ((Double)Aerometer.beepPitch.get()).floatValue();
                this.getLevel().playLocalSound(this.getStartPos(), this.getBeepSound(), SoundSource.NEUTRAL, volume, pitch, false);
                this.lastBeep = CommonTime.Stamp.now();
                this.lastBeepedAlarmLevel = alarmLevel;
            }
        }
    }

    protected SoundEvent getBeepSound() {
        Sounds sounds = AdPother.getInstance().sounds;
        return switch (this.getAlarmLevel().ordinal()) {
            case 3 -> (SoundEvent)sounds.beep_x3.get();
            case 2 -> (SoundEvent)sounds.beep_x2.get();
            default -> (SoundEvent)sounds.beep_x1.get();
        };
    }

    public record Result(boolean explosionRisk, int gasBlocksAround) {
    }

    public static enum AlarmLevel {
        NONE,
        LOW,
        MEDIUM,
        HIGH;

    }

    public static class Searcher
    extends WorldSearch.BlockChain {
        protected final WorldBounds searchBounds;
        protected boolean explosionRisk;

        public Searcher(LevelAccessor level, BlockPos startPos, WorldBounds searchBounds) {
            super(level, startPos, searchBounds.size());
            this.searchBounds = searchBounds;
        }

        protected boolean isOutsideBounds(BlockPos pos) {
            if (!this.searchBounds.encloses(pos)) {
                return true;
            }
            return super.isOutsideBounds(pos);
        }

        protected boolean isValidPath(BlockPos pos) {
            if (this.level.isEmptyBlock(pos)) {
                return true;
            }
            if (this.lastUsedDirection == null) {
                return true;
            }
            BlockPos last = pos.relative(this.lastUsedDirection.getOpposite());
            return !this.level.getBlockState(last).isFaceSturdy((BlockGetter)this.level, last, this.lastUsedDirection) && !this.level.getBlockState(pos).isFaceSturdy((BlockGetter)this.level, pos, this.lastUsedDirection.getOpposite());
        }

        protected boolean isValidBlock(BlockPos pos) {
            return this.level.getBlockState(pos).getBlock() instanceof AbstractGas;
        }

        protected boolean onValidFound(BlockPos blockPos) {
            if (!this.explosionRisk) {
                this.explosionRisk = GasExplosion.in(this.level).position(blockPos).action(gasChain -> {
                    for (BlockPos pos : gasChain.getFound().elements()) {
                        if (this.foundEnoughGasBlocks()) break;
                        if (this.isOutsideBounds(pos)) continue;
                        this.getChain().add((Object)pos);
                        this.getFound().add((Object)pos);
                    }
                }).tryTrigger();
            }
            return !this.foundEnoughGasBlocks();
        }

        protected boolean foundEnoughGasBlocks() {
            return this.getFound().size() >= GAS_BLOCKS_THRESHOLD.getMax();
        }

        public Result buildWithResult() {
            this.build();
            return new Result(this.explosionRisk, this.getFound().size());
        }
    }
}

