/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.recipes;

import com.endertech.minecraft.forge.data.INetSerializable;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class FilterChangeRecipe
extends CustomRecipe
implements INetSerializable<FilterChangeRecipe> {
    protected final AdPother mod;
    protected Map<Pollutant<?>, Set<Item>> filterMaterials;

    public FilterChangeRecipe(AdPother mod) {
        super(CraftingBookCategory.MISC);
        this.mod = mod;
        this.filterMaterials = mod.pollutants.streamAll().collect(Collectors.toUnmodifiableMap(key -> key, pollutant -> pollutant.getFilterMaterials().getMaterials()));
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        if (craftingInput.ingredientCount() < 2) {
            return false;
        }
        if (this.getStorageItem(craftingInput).isEmpty()) {
            return false;
        }
        if (this.getTargetPollutants(craftingInput).isEmpty()) {
            return false;
        }
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemStack = craftingInput.getItem(i);
            if (itemStack.isEmpty() || this.isFilterMaterial(itemStack) || !this.getStorageItem(itemStack).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider registries) {
        ItemStack itemStack = this.getStorageItem(craftingInput).orElse(ItemStack.EMPTY).copy();
        List<Pollutant<?>> targetPollutants = this.getTargetPollutants(craftingInput);
        if (!itemStack.isEmpty() && !targetPollutants.isEmpty()) {
            this.getStorageItem(itemStack).ifPresent(storage -> storage.installFiltersFor(itemStack, targetPollutants.toArray(new Pollutant[0])));
        }
        return itemStack;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)this.mod.recipeSerializers.filterChange.get();
    }

    protected Optional<? extends IStorageItem> getStorageItem(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof VacuumBag) {
            VacuumBag item2 = (VacuumBag)item;
            return Optional.of(item2);
        }
        return this.mod.respirators.get(itemStack);
    }

    protected boolean isFilterMaterial(ItemStack itemStack) {
        Item item = itemStack.getItem();
        return this.filterMaterials.values().stream().anyMatch(materials -> materials.contains(item));
    }

    protected Optional<ItemStack> getStorageItem(CraftingInput craftingInput) {
        ItemStack foundItem = ItemStack.EMPTY;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemStack = craftingInput.getItem(i);
            if (!this.getStorageItem(itemStack).isPresent()) continue;
            if (foundItem.isEmpty()) {
                foundItem = itemStack;
                continue;
            }
            return Optional.empty();
        }
        return foundItem.isEmpty() ? Optional.empty() : Optional.of(foundItem);
    }

    protected List<? extends Pollutant<?>> getTargetPollutants(CraftingInput craftingInput) {
        return this.filterMaterials.entrySet().stream().filter(entry -> craftingInput.items().stream().anyMatch(stack -> ((Set)entry.getValue()).contains(stack.getItem()))).map(Map.Entry::getKey).toList();
    }

    public FilterChangeRecipe readFrom(FriendlyByteBuf buf) {
        CompoundTag compound = buf.readNbt();
        if (compound != null) {
            this.filterMaterials = this.filterMaterials.keySet().stream().collect(Collectors.toUnmodifiableMap(k -> k, pollutant -> {
                String key = pollutant.getSimpleName();
                String[] strings = TagHelper.getStringArray((CompoundTag)compound, (String)key);
                return Stream.of(strings).map(ResourceLocation::parse).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
            }));
        }
        return this;
    }

    public FriendlyByteBuf writeTo(FriendlyByteBuf buf) {
        CompoundTag compound = new CompoundTag();
        this.filterMaterials.forEach((pollutant, items) -> {
            String key = pollutant.getSimpleName();
            String[] strings = items.stream().map(ForgeItem::getRegistryName).map(ResourceLocation::toString).toList().toArray(new String[0]);
            TagHelper.putStringArray((CompoundTag)compound, (String)key, (String[])strings);
        });
        return buf.writeNbt((Tag)compound);
    }

    public static class Serializer
    implements RecipeSerializer<FilterChangeRecipe> {
        protected final AdPother mod;
        private final MapCodec<FilterChangeRecipe> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, FilterChangeRecipe> streamCodec;

        public Serializer(AdPother mod) {
            this.mod = mod;
            this.codec = MapCodec.unit(() -> new FilterChangeRecipe(mod));
            this.streamCodec = StreamCodec.of((buffer, recipe) -> recipe.writeTo((FriendlyByteBuf)buffer), buffer -> new FilterChangeRecipe(mod).readFrom((FriendlyByteBuf)buffer));
        }

        public MapCodec<FilterChangeRecipe> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FilterChangeRecipe> streamCodec() {
            return this.streamCodec;
        }
    }
}

