/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.common.CachedValue;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.impacts.AbstractPollutionImpacts;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;

@EventBusSubscriber(modid="adpother", value={Dist.CLIENT})
public final class AcidRain {
    static final ResourceLocation VANILLA_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"adpother", (String)"textures/environment/acid_rain.png");
    static final ResourceLocation WEATHER2_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"adpother", (String)"environment/acid_rain_weather2");
    static final CachedValue<Boolean> ACID_RAIN = CachedValue.of(() -> {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        EntityPollution pollution = WorldData.getEntityPollution((Entity)player);
        return pollution.getPollutants().anyMatch(pollutant -> pollutant.canAffectEntity((Entity)player, AbstractPollutionImpacts.ImpactType.RAIN, pollution.getInfluenceOf((Pollutant<?>)((Object)((Object)pollutant)))));
    }, (CommonTime.Interval)GameTime.second().getInterval());
    static TextureAtlasSprite weather2Sprite;

    static boolean isAcidRain() {
        return (Boolean)ACID_RAIN.get();
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureAtlasStitchedEvent event) {
        TextureAtlas atlas = event.getAtlas();
        if (atlas.location().equals((Object)TextureAtlas.LOCATION_PARTICLES)) {
            weather2Sprite = atlas.getSprite(WEATHER2_LOCATION);
        }
    }

    public static ResourceLocation getRainTexture(ResourceLocation defaultTexture) {
        return AcidRain.isAcidRain() ? VANILLA_LOCATION : defaultTexture;
    }

    public static final TextureAtlasSprite getWeather2Sprite(TextureAtlasSprite defaultSprite) {
        return AcidRain.isAcidRain() ? weather2Sprite : defaultSprite;
    }
}

