/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.minecraft.forge.client.renderer.SimpleEntityRenderState;
import com.endertech.minecraft.forge.client.renderer.SimpleEntityRenderer;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public class GasRenderer
extends SimpleEntityRenderer<GasEntity> {
    protected final BlockRenderDispatcher blockRenderDispatcher;

    public GasRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.blockRenderDispatcher = context.getBlockRenderDispatcher();
    }

    public ResourceLocation getTextureLocation(SimpleEntityRenderState<GasEntity> state) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void submit(SimpleEntityRenderState<GasEntity> renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        GasEntity entity = (GasEntity)renderState.entity;
        Level level = entity.level();
        BlockState carriedGas = entity.getCarriedBlockState().orElse(null);
        if (carriedGas == null) {
            return;
        }
        if (carriedGas.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(entity.getRenderOffset(Direction.Axis.X), entity.getRenderOffset(Direction.Axis.Y), entity.getRenderOffset(Direction.Axis.Z));
        poseStack.scale(entity.getRenderScale(Direction.Axis.X), entity.getRenderScale(Direction.Axis.Y), entity.getRenderScale(Direction.Axis.Z));
        RenderType renderType = RenderType.translucentMovingBlock();
        BlockPos blockPos = entity.blockPosition();
        BlockStateModel blockStateModel = this.blockRenderDispatcher.getBlockModel(carriedGas);
        nodeCollector.submitBlockModel(poseStack, renderType, blockStateModel, 1.0f, 1.0f, 1.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
        super.submit(renderState, poseStack, nodeCollector, cameraRenderState);
    }
}

