/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.world.GameWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public interface IWaterLoggable
extends SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public static FluidState getFluidState(BlockState state, boolean falling) {
        return IWaterLoggable.isWaterlogged(state) ? Fluids.WATER.getSource(falling) : Fluids.EMPTY.defaultFluidState();
    }

    public static BlockState getStateForPlacementAt(LevelReader level, BlockPos pos, BlockState originalState) {
        if (originalState.hasProperty((Property)WATERLOGGED) && GameWorld.isWaterSource(level, pos)) {
            return (BlockState)originalState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return originalState;
    }

    public static BlockState getStateForPlacement(BlockPlaceContext context, BlockState originalState) {
        return IWaterLoggable.getStateForPlacementAt((LevelReader)context.getLevel(), context.getClickedPos(), originalState);
    }

    public static BlockState updateFluidPostPlacement(LevelReader level, ScheduledTickAccess tickAccess, BlockPos currentPos, BlockState stateIn) {
        if (IWaterLoggable.isWaterlogged(stateIn)) {
            tickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return stateIn;
    }

    public static boolean isWaterlogged(BlockState state) {
        return state.hasProperty((Property)WATERLOGGED) && (Boolean)state.getValue((Property)WATERLOGGED) != false;
    }
}

