/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.minecraft.forge.data.GamePath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;

public final class GameRendering {
    public static final ResourceLocation EMPTY_TEXTURE = GamePath.texture((GamePath.Folders)GamePath.Folders.NONE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forgeendertech", (String)"empty"), (String[])new String[0]).location;

    public static void line(float width, Vect3d from, Vect3d to) {
        RenderSystem.lineWidth((float)width);
        GameRendering.begin(1);
        GameRendering.vertex(from);
        GameRendering.vertex(to);
        GameRendering.end();
    }

    public static void begin(int mode) {
        RenderSystem.assertOnRenderThread();
        GL11.glBegin((int)mode);
    }

    public static void vertex(Vect3d vect) {
        RenderSystem.assertOnRenderThread();
        GL11.glVertex3d((double)vect.x, (double)vect.y, (double)vect.z);
    }

    public static void vertex3f(float x, float y, float z) {
        RenderSystem.assertOnRenderThread();
        GL11.glVertex3f((float)x, (float)y, (float)z);
    }

    public static void end() {
        RenderSystem.assertOnRenderThread();
        GL11.glEnd();
    }

    public static void enable(int target) {
        RenderSystem.assertOnRenderThread();
        GL11.glEnable((int)target);
    }

    public static void disable(int target) {
        RenderSystem.assertOnRenderThread();
        GL11.glDisable((int)target);
    }
}

