/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.EquipmentItem;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public abstract class GlassMeter
extends EquipmentItem {
    protected final Map<ItemStack, Entity> carriers = new ConcurrentHashMap<ItemStack, Entity>();
    private final ChatFormatting nameColor;

    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof GlassMeter) {
            BlockState state;
            GlassMeter meter = (GlassMeter)item;
            if (!player.swinging && (state = event.getLevel().getBlockState(event.getPos())).isSolid()) {
                meter.onHit(stack, player);
            }
        }
    }

    public GlassMeter(UnitConfig config, Properties<?> props) {
        super(config, (EquipmentItem.Properties<?>)props);
        this.nameColor = props.nameColor;
    }

    protected void onHit(ItemStack stack, Player player) {
        ServerPlayer serverPlayer;
        ServerLevel serverLevel;
        if (player instanceof ServerPlayer && (serverLevel = (serverPlayer = (ServerPlayer)player).level()) instanceof ServerLevel) {
            ServerLevel level = serverLevel;
            GlassMeter.hurtNotDestroy(stack, 1, level, serverPlayer, item -> level.playSound(null, player.blockPosition(), SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f));
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        this.onHit(stack, player);
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        this.onHit(stack, player);
        return super.onDroppedByPlayer(stack, player);
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BLOCK;
    }

    public ChatFormatting getNameColor() {
        return this.nameColor;
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).plainCopy().withStyle(this.getNameColor());
    }

    public static class Properties<T extends Properties<T>>
    extends EquipmentItem.Properties<T> {
        public ChatFormatting nameColor = ChatFormatting.WHITE;

        public static Properties<?> of(ResourceKey<Item> key) {
            return new Properties<Properties>(Properties.class, key);
        }

        protected Properties(Class<T> selfClass, ResourceKey<Item> key) {
            super(selfClass, key);
            this.repairMaterial = UnitId.from("#forge:glass_panes");
        }

        public T nameColor(ChatFormatting nameColor) {
            this.nameColor = nameColor;
            return (T)((Properties)this.self);
        }
    }
}

