/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.properties.synched;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.data.IReloadableData;
import com.endertech.minecraft.forge.properties.synched.AbstractSynchedProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class SynchedProperties
implements INBTSerializable<SynchedProperties>,
IReloadableData {
    public final String category;
    protected final List<AbstractSynchedProperty<?>> properties = new ArrayList();

    public SynchedProperties(String category) {
        this.category = category;
    }

    public <P extends AbstractSynchedProperty<?>> P add(P property) {
        this.properties.add(property);
        return property;
    }

    public List<AbstractSynchedProperty<?>> list() {
        return Collections.unmodifiableList(this.properties);
    }

    public void define(AbstractForgeMod.ConfigValueBuilder builder) {
        builder.push(this.category);
        this.properties.forEach(p -> p.define(builder));
        builder.pop();
    }

    @Override
    public void loadData() {
        this.properties.forEach(prop -> {
            if (prop instanceof IReloadableData) {
                IReloadableData data = (IReloadableData)((Object)prop);
                data.loadData();
            }
        });
    }

    public void resetToConfigValues() {
        this.properties.forEach(AbstractSynchedProperty::resetToConfigValue);
    }

    @Override
    public SynchedProperties readFrom(CompoundTag compound) {
        CompoundTag tag = compound.getCompoundOrEmpty(this.category);
        this.properties.forEach(p -> p.readFrom(tag));
        return this;
    }

    @Override
    public CompoundTag writeTo(CompoundTag compound) {
        CompoundTag tag = new CompoundTag();
        this.properties.forEach(p -> p.writeTo(tag));
        compound.put(this.category, (Tag)tag);
        return compound;
    }
}

