/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tiles;

import com.endertech.minecraft.forge.network.TileSharedDataMsg;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public abstract class ForgeTile
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T extends BlockEntity> BlockEntityType<T> create(BlockEntityType.BlockEntitySupplier<? extends T> factory, Collection<? extends Block> validBlocks) {
        return new BlockEntityType(factory, Set.copyOf(validBlocks));
    }

    public static <T extends BlockEntity> BlockEntityType<T> create(BlockEntityType.BlockEntitySupplier<? extends T> factory, Block ... validBlocks) {
        return new BlockEntityType(factory, Set.of(validBlocks));
    }

    public static Optional<ResourceLocation> getRegistryName(BlockEntity tile) {
        return Optional.ofNullable(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)tile.getType()));
    }

    public ForgeTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::saveCustomOnly);
    }

    public void onDataPacket(Connection connection, ValueInput data) {
        super.onDataPacket(connection, data);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void handleUpdateTag(ValueInput tag) {
        this.loadWithComponents(tag);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.readSharedData(input);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.writeSharedData(output);
    }

    public CompoundTag getSharedData() {
        Optional<RegistryAccess> registry = Optional.ofNullable(this.getLevel()).map(Level::registryAccess);
        if (registry.isPresent()) {
            try (ProblemReporter.ScopedCollector collector = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
                TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)collector, (HolderLookup.Provider)((HolderLookup.Provider)registry.get()));
                this.writeSharedData((ValueOutput)output);
                CompoundTag compoundTag = output.buildResult();
                return compoundTag;
            }
        }
        return new CompoundTag();
    }

    public void syncWithClients() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            new TileSharedDataMsg(this.getSharedData(), this.getBlockPos()).sendToAllObservingChunk(serverLevel, this.getBlockPos());
            this.setChanged();
        }
    }

    public abstract void readSharedData(ValueInput var1);

    public abstract void writeSharedData(ValueOutput var1);
}

