/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tiles;

import com.endertech.minecraft.forge.tiles.ForgeTile;
import com.endertech.minecraft.forge.tiles.TileInventory;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.RangedResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;

public abstract class ForgeTileWithInventory
extends ForgeTile
implements MenuProvider {
    public ForgeTileWithInventory(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract TileInventory getTileInventory();

    public abstract RangedResourceHandler<ItemResource> getInputInventory();

    public abstract RangedResourceHandler<ItemResource> getOutputInventory();

    @Nullable
    protected abstract AbstractContainerMenu createContainer(int var1, Player var2, Inventory var3, TileInventory var4);

    @Nullable
    public final AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return this.createContainer(id, player, playerInventory, this.getTileInventory());
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.getTileInventory().deserialize(input);
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.getTileInventory().serialize(output);
    }

    public boolean canInteractWith(Player player) {
        return !this.isRemoved() && this.getBlockPos().distSqr((Vec3i)player.blockPosition()) <= 64.0;
    }
}

