/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tiles;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.GamePath;
import java.awt.Dimension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.item.ResourceHandlerSlot;

public class TileInventory
extends ItemStacksResourceHandler {
    protected final BlockEntity tile;

    public TileInventory(BlockEntity tile, int size) {
        super(size);
        this.tile = tile;
    }

    public BlockEntity getTile() {
        return this.tile;
    }

    protected void onContentsChanged(int index, ItemStack previousContents) {
        if (this.tile != null) {
            this.tile.setChanged();
        }
    }

    public static abstract class AbstractScreen<T extends AbstractContainerMenu>
    extends AbstractContainerScreen<T> {
        protected final GuiTexture texture;

        public AbstractScreen(T container, Inventory inv, Component title, GuiTexture texture) {
            super(container, inv, title);
            this.texture = texture;
            this.imageWidth = texture.size.width;
            this.imageHeight = texture.size.height;
        }

        public GuiTexture getTexture() {
            return this.texture;
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }

        protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
            int i = (this.width - this.imageWidth) / 2;
            int j = (this.height - this.imageHeight) / 2;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture.location, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        }

        public static class GuiTexture {
            public final Dimension size;
            public final ResourceLocation location;

            public GuiTexture(AbstractForgeMod mod, String name, int width, int height) {
                this.location = GamePath.guiTexture((ResourceLocation)mod.getNamespace().location((String)name), (String[])new String[0]).location;
                this.size = new Dimension(width, height);
            }
        }
    }

    public static abstract class AbstractContainer
    extends AbstractContainerMenu {
        public static final Dimension PLAYER_INVENTORY = new Dimension(9, 3);
        public static final Dimension SLOT_SIZE = new Dimension(18, 18);
        protected final Inventory playerInventory;
        protected final TileInventory tileInventory;

        public AbstractContainer(MenuType<?> type, int id, Inventory playerInventory, TileInventory tileInventory) {
            super(type, id);
            this.playerInventory = playerInventory;
            this.tileInventory = tileInventory;
        }

        public Inventory getPlayerInventory() {
            return this.playerInventory;
        }

        public TileInventory getTileInventory() {
            return this.tileInventory;
        }

        public AbstractContainer addPlayerSlots(int startX, int startY) {
            for (int row = 0; row < AbstractContainer.PLAYER_INVENTORY.height; ++row) {
                for (int col = 0; col < AbstractContainer.PLAYER_INVENTORY.width; ++col) {
                    int x = startX + col * this.slotSize().width;
                    int y = startY + row * this.slotSize().height;
                    this.addSlot(new Slot((Container)this.playerInventory, AbstractContainer.PLAYER_INVENTORY.width + col + row * AbstractContainer.PLAYER_INVENTORY.width, x, y));
                }
            }
            for (int col = 0; col < AbstractContainer.PLAYER_INVENTORY.width; ++col) {
                int x = startX + col * this.slotSize().width;
                int y = startY + 58;
                this.addSlot(new Slot((Container)this.playerInventory, col, x, y));
            }
            return this;
        }

        public Dimension slotSize() {
            return SLOT_SIZE;
        }

        public ItemStack quickMoveStack(Player player, int index) {
            ItemStack itemstack = ItemStack.EMPTY;
            Slot slot = (Slot)this.slots.get(index);
            if (slot != null && slot.hasItem()) {
                ItemStack itemstack1 = slot.getItem();
                itemstack = itemstack1.copy();
                int size = this.tileInventory.size();
                if (index < size ? !this.moveItemStackTo(itemstack1, size, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, size, false)) {
                    return ItemStack.EMPTY;
                }
                if (itemstack1.isEmpty()) {
                    slot.set(ItemStack.EMPTY);
                } else {
                    slot.setChanged();
                }
            }
            return itemstack;
        }

        public boolean stillValid(Player player) {
            BlockEntity tile = this.getTileInventory().getTile();
            Level world = tile.getLevel();
            BlockPos pos = tile.getBlockPos();
            Block block = tile.getBlockState().getBlock();
            return AbstractContainer.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)world, (BlockPos)pos), (Player)player, (Block)block);
        }
    }

    public static class ItemSlot
    extends ResourceHandlerSlot {
        public final TileInventory tileInventory;

        public ItemSlot(TileInventory tileInventory, int index, int xPosition, int yPosition) {
            super((ResourceHandler)tileInventory, (arg_0, arg_1, arg_2) -> ((TileInventory)tileInventory).set(arg_0, arg_1, arg_2), index, xPosition, yPosition);
            this.tileInventory = tileInventory;
        }
    }
}

