/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.core.IPostInit;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.neoforged.neoforge.common.util.Lazy;

public abstract class UnitsInit<U>
implements IPostInit {
    private final AbstractForgeMod mod;
    protected final Map<String, Lazy<? extends U>> units = new HashMap<String, Lazy<? extends U>>();

    public UnitsInit(AbstractForgeMod mod) {
        this.mod = mod;
        mod.addPostInitRunnable(this::onPostInit);
    }

    protected <L extends U> Lazy<L> addUnit(String name, Supplier<L> supplier) {
        Lazy lazy = Lazy.of(supplier);
        this.units.put(name, lazy);
        return lazy;
    }

    protected void removeAll() {
        this.units.clear();
    }

    @Override
    public void onPostInit() {
        this.streamAll().forEach(unit -> {
            if (unit instanceof IPostInit) {
                IPostInit init = (IPostInit)unit;
                init.onPostInit();
            }
            if (unit instanceof IHaveConfig) {
                IHaveConfig config = (IHaveConfig)unit;
                config.saveConfig();
            }
        });
    }

    public Map<String, Lazy<? extends U>> mapAll() {
        return Collections.unmodifiableMap(this.units);
    }

    public Stream<U> streamAll() {
        return this.units.values().stream().map(Lazy::get);
    }

    public AbstractForgeMod getMod() {
        return this.mod;
    }

    public static Path getConfigsDir(AbstractForgeMod mod, Class<?> clazz) {
        return mod.getConfigsDir().resolve(clazz.getSimpleName());
    }

    public Path getConfigsDir() {
        return UnitsInit.getConfigsDir(this.getMod(), this.getClass());
    }

    public UnitConfig createConfig(String name) {
        return UnitConfig.in(this.getConfigsDir(), name);
    }
}

