/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.configs.BlockStateList;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class FluidBlockStateList
extends BlockStateList {
    public FluidBlockStateList(UnitConfig config, String category, String key, String[] defaultValues, String comment) {
        super(config, category, key, defaultValues, comment);
    }

    protected void parseConfigValues() {
        this.states = new BlockStatesSet();
        for (String string : this.configValues) {
            try {
                Collection fluids;
                UnitId id = UnitId.from((String)string);
                if (id.isEmpty()) {
                    throw new Exception();
                }
                this.states.add(id);
                if (!id.isTag() || (fluids = id.getAllMatchedFluids()) == null) continue;
                for (Fluid fluid : fluids) {
                    Block block = fluid.defaultFluidState().createLegacyBlock().getBlock();
                    if (block == Blocks.AIR) continue;
                    this.states.addAllFor(block);
                }
            }
            catch (Exception e) {
                this.logParsingError(string);
            }
        }
    }

    public boolean contains(FluidState fluid) {
        return this.states.contains((Object)fluid.createLegacyBlock());
    }

    public void listFluids(List<String> list) {
        this.states.forEach(state -> list.add(state.toString()));
        this.states.getBlocksWithAllStates().forEach(block -> list.add(block.toString()));
    }
}

