/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.pollution.IFilterFrame;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;

public interface IPurifier {
    public boolean hasProperInput(LevelReader var1, BlockPos var2);

    public boolean hasProperOutput(LevelReader var1, BlockPos var2);

    public BlockPos getOutputPos(LevelReader var1, BlockPos var2);

    public BlockPos getPumpPos(LevelReader var1, BlockPos var2);

    default public boolean isActive(LevelReader world, BlockPos filterPos) {
        BlockPos pumpPos = this.getPumpPos(world, filterPos);
        return this.hasActivePump(world, pumpPos) && this.hasProperInput(world, pumpPos) && this.hasActiveFilter(world, filterPos) && this.hasProperOutput(world, this.getOutputPos(world, filterPos));
    }

    default public boolean hasActiveFilter(LevelReader world, BlockPos filterPos) {
        Block block = world.getBlockState(filterPos).getBlock();
        return block instanceof IFilterFrame && block instanceof ISmokeContainer && ((ISmokeContainer)block).isActive((BlockGetter)world, filterPos);
    }

    default public boolean hasActivePump(LevelReader world, BlockPos pumpPos) {
        return GameWorld.SmokeContainers.isActivePump((LevelReader)world, (BlockPos)pumpPos);
    }

    default public void spawnParticle(Level world, BlockPos filterPos, SimpleParticleType type) {
        BlockPos pos = this.getOutputPos((LevelReader)world, filterPos);
        world.addParticle((ParticleOptions)type, (double)pos.getX() + CommonMath.Random.between((double)0.4, (double)0.6), (double)pos.getY() + CommonMath.Random.between((double)0.0, (double)0.6), (double)pos.getZ() + CommonMath.Random.between((double)0.4, (double)0.6), 0.0, 0.0, 0.0);
    }
}

