/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GasRenderer
extends EntityRenderer<GasEntity> {
    public GasRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
    }

    public ResourceLocation getTextureLocation(GasEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void render(GasEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Level level = entity.level();
        BlockState carriedGas = entity.getCarriedBlockState().orElse(null);
        if (carriedGas == null) {
            return;
        }
        if (carriedGas.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(entity.getRenderOffset(Direction.Axis.X), entity.getRenderOffset(Direction.Axis.Y), entity.getRenderOffset(Direction.Axis.Z));
        poseStack.scale(entity.getRenderScale(Direction.Axis.X), entity.getRenderScale(Direction.Axis.Y), entity.getRenderScale(Direction.Axis.Z));
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        RenderType renderType = RenderType.translucentMovingBlock();
        BlockPos blockPos = entity.blockPosition();
        dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, dispatcher.getBlockModel(carriedGas), carriedGas, blockPos, poseStack, buffer.getBuffer(renderType), false, RandomSource.create(), carriedGas.getSeed(blockPos), OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

