/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateCarrier
extends ForgeEntity {
    protected static final String CARRIED_STATE_TAG = "carried_state";
    private static final EntityDataAccessor<Optional<BlockState>> CARRIED_BLOCK_STATE = SynchedEntityData.defineId(BlockStateCarrier.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_STATE);

    public BlockStateCarrier(EntityType<?> type, Level world, BlockPos pos, BlockState carriedState) {
        super(type, world);
        Vect3d centeredPos = BlockStateCarrier.getCenteredPosTo(pos);
        this.setAllPositions(centeredPos);
        this.setCarriedBlockState(Optional.ofNullable(carriedState));
    }

    public BlockStateCarrier(EntityType<?> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CARRIED_BLOCK_STATE, Optional.empty());
    }

    public Optional<BlockState> getCarriedBlockState() {
        return (Optional)this.getEntityData().get(CARRIED_BLOCK_STATE);
    }

    protected void setCarriedBlockState(Optional<BlockState> newState) {
        this.getEntityData().set(CARRIED_BLOCK_STATE, newState);
    }

    public boolean carriesSameBlock(Optional<? extends Block> block) {
        return this.getCarriedBlockState().map(state -> state.getBlock()).equals(block);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        this.getCarriedBlockState().ifPresent(state -> compound.put(CARRIED_STATE_TAG, (Tag)NbtUtils.writeBlockState((BlockState)state)));
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        BlockState state = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound(CARRIED_STATE_TAG));
        this.getEntityData().set(CARRIED_BLOCK_STATE, Optional.of(state));
    }
}

