/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.properties.synched;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.properties.synched.AbstractSynchedProperty;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;

public class SynchedEnumProperty<E extends Enum<E>>
extends AbstractSynchedProperty<E> {
    public final Predicate<E> validator;

    public SynchedEnumProperty(String name, E defaultValue, Predicate<E> validator, String comment) {
        super(name, defaultValue, comment);
        this.validator = validator;
    }

    @Override
    public void define(AbstractForgeMod.ConfigValueBuilder builder) {
        this.configValue = builder.comment(this.comment).defineEnum(this.name, (Enum)this.defaultValue, this.validator);
    }

    @Override
    public E readFrom(CompoundTag compound) {
        this.currentValue = ((Enum[])((Enum)this.defaultValue).getDeclaringClass().getEnumConstants())[compound.getInt(this.name)];
        return (E)this.currentValue;
    }

    @Override
    public CompoundTag writeTo(CompoundTag compound) {
        compound.putInt(this.name, ((Enum)this.getValue()).ordinal());
        return compound;
    }
}

