function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'de/cech12/brickfurnace/blockentity/AbstractBrickFurnaceBlockEntity',
		'methodName' : 'tick',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lde/cech12/brickfurnace/blockentity/AbstractBrickFurnaceBlockEntity;)V'
	}


	var node = {
		'class' : 'net/minecraft/world/item/ItemStack',
		'methodName' : 'shrink',
		'methodDesc' : '(I)V'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFurnaceFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
		insnPushValue(1, "fuel amount"),
		insnLoadObj(3, "furnace tile"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, [].concat(instructionsDupValue2("fuel stack"), instructions));
				return method;
			}
		}
	}
}