function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/mrh0/createaddition/blocks/crude_burner/CrudeBurnerTileEntity',
		'methodName' : 'crudeServerTick',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/mrh0/createaddition/blocks/crude_burner/CrudeBurnerTileEntity;)V'
	}

	var node = {
		'class' : 'net/neoforged/neoforge/fluids/capability/templates/FluidTank',
		'methodName' : 'drain',
		'methodDesc' : '(ILnet/neoforged/neoforge/fluids/capability/IFluidHandler$FluidAction;)Lnet/neoforged/neoforge/fluids/FluidStack;'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/neoforged/neoforge/fluids/FluidStack;Lnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [ 
		insnDup("fuel fluidstack"),
		insnLoadObj(3, "crude burner tile"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}