function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/drmangotea/tfmg/content/engines/base/AbstractEngineBlockEntity',
		'methodName' : 'manageFuelAndExhaust',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'com/drmangotea/tfmg/content/engines/base/EngineFluidTank',
		'methodName' : 'forceDrain',
		'methodDesc' : '(ILnet/neoforged/neoforge/fluids/capability/IFluidHandler$FluidAction;)Lnet/neoforged/neoforge/fluids/FluidStack;'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/neoforged/neoforge/fluids/FluidStack;Lnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [ 
		insnDup("fuel fluidstack"),
		insnLoadThis("engine"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}