function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/neoforged/neoforge/common/extensions/IBlockStateExtension',
		'methodName' : 'onCaughtFire',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Lnet/minecraft/world/entity/LivingEntity;)V'
	}

	var self = {
		'class' : 'net/neoforged/neoforge/common/extensions/IBlockStateExtension',
		'methodName' : 'self',
		'methodDesc' : '()Lnet/minecraft/world/level/block/state/BlockState;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onBlockBurned',
		'methodDesc' : '(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V'
	}

	var instructions = [ 
		insnLoadThis("IBlockStateExtension"),
		insnInvokeInterface(self),
		insnLoadObj(1, "world"), 
		insnLoadObj(2, "pos"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions);
				return method;
			}
		}
	}
}