function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'me/desht/pneumaticcraft/common/block/entity/compressor/AirCompressorBlockEntity',
		'methodName' : 'tickServer',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'net/minecraft/world/item/ItemStack',
		'methodName' : 'hasCraftingRemainingItem',
		'methodDesc' : '()Z'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFurnaceFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
		insnDup("fuel stack"),
		insnPushValue(1, "fuel amount"),
		insnLoadThis("air compressor tile"), 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}