function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'slimeknights/tconstruct/smeltery/block/entity/module/FuelModule',
		'methodName' : 'tryLiquidFuel',    
		'methodDesc' : '(Lnet/neoforged/neoforge/fluids/capability/IFluidHandler;Z)I'
	}

	var node = {
		'class' : 'net/neoforged/neoforge/fluids/capability/IFluidHandler',
		'methodName' : 'drain', 
		'methodDesc' : '(Lnet/neoforged/neoforge/fluids/FluidStack;Lnet/neoforged/neoforge/fluids/capability/IFluidHandler$FluidAction;)Lnet/neoforged/neoforge/fluids/FluidStack;'
	}
	
	var parent = {
		'class' : 'slimeknights/tconstruct/smeltery/block/entity/module/FuelModule',
		'fieldName' : 'parent',
		'fieldDesc' : 'Lslimeknights/mantle/block/entity/MantleBlockEntity;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/neoforged/neoforge/fluids/FluidStack;Lnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
		insnDup("fuel fluid stack"),
		insnLoadThis("fuel module"),
		insnGetField(parent),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}