function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/dries007/tfc/common/blockentities/BlastFurnaceBlockEntity',
		'methodName' : 'consumeFuel',
		'methodDesc' : '()Z'
	}

    var node = {
		'class' : 'net/dries007/tfc/util/data/Fuel',
		'methodName' : 'get',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;)Lnet/dries007/tfc/util/data/Fuel;'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFurnaceFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
	    insnDup("fuel"),
		insnPushValue(1, "fuel amount"),
		insnLoadThis("tile"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}